/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import bk-shade.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import bk-shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import bk-shade.com.google.proto_2.6.1.ByteString;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.processor.RequestProcessor;
import org.apache.bookkeeper.proto.AuthHandler;
import org.apache.bookkeeper.proto.BKStats;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.GetBookieInfoProcessorV3;
import org.apache.bookkeeper.proto.LongPollReadEntryProcessorV3;
import org.apache.bookkeeper.proto.ReadEntryProcessor;
import org.apache.bookkeeper.proto.ReadEntryProcessorV3;
import org.apache.bookkeeper.proto.ReadLacProcessorV3;
import org.apache.bookkeeper.proto.RequestUtils;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.proto.WriteEntryProcessor;
import org.apache.bookkeeper.proto.WriteEntryProcessorV3;
import org.apache.bookkeeper.proto.WriteLacProcessorV3;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BookieRequestProcessor.class);
    private final ServerConfiguration serverCfg;
    final Bookie bookie;
    private final OrderedSafeExecutor readThreadPool;
    private final OrderedSafeExecutor writeThreadPool;
    private final SecurityHandlerFactory shFactory;
    private final OrderedSafeExecutor longPollThreadPool;
    private final HashedWheelTimer requestTimer;
    private final BKStats bkStats = BKStats.getInstance();
    private final boolean statsEnabled;
    final OpStatsLogger addRequestStats;
    final OpStatsLogger addEntryStats;
    final OpStatsLogger readRequestStats;
    final OpStatsLogger readEntryStats;
    final OpStatsLogger fenceReadRequestStats;
    final OpStatsLogger fenceReadEntryStats;
    final OpStatsLogger fenceReadWaitStats;
    final OpStatsLogger readEntrySchedulingDelayStats;
    final OpStatsLogger longPollPreWaitStats;
    final OpStatsLogger longPollWaitStats;
    final OpStatsLogger longPollReadStats;
    final OpStatsLogger longPollReadRequestStats;
    final Counter readLastEntryNoEntryErrorCounter;
    final OpStatsLogger writeLacRequestStats;
    final OpStatsLogger writeLacStats;
    final OpStatsLogger readLacRequestStats;
    final OpStatsLogger readLacStats;
    final OpStatsLogger getBookieInfoRequestStats;
    final OpStatsLogger getBookieInfoStats;
    final OpStatsLogger channelWriteStats;

    public BookieRequestProcessor(ServerConfiguration serverCfg, Bookie bookie, StatsLogger statsLogger, SecurityHandlerFactory shFactory) throws SecurityException {
        this.serverCfg = serverCfg;
        this.bookie = bookie;
        this.readThreadPool = this.createExecutor(this.serverCfg.getNumReadWorkerThreads(), "BookieReadThread-" + serverCfg.getBookiePort());
        this.writeThreadPool = this.createExecutor(this.serverCfg.getNumAddWorkerThreads(), "BookieWriteThread-" + serverCfg.getBookiePort());
        this.longPollThreadPool = this.createExecutor(this.serverCfg.getNumLongPollWorkerThreads(), "BookieLongPollThread-" + serverCfg.getBookiePort());
        this.requestTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("BookieRequestTimer-%d").build(), (long)this.serverCfg.getRequestTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.serverCfg.getRequestTimerNumTicks());
        this.shFactory = shFactory;
        if (shFactory != null) {
            shFactory.init(SecurityHandlerFactory.NodeType.Server, serverCfg);
        }
        this.statsEnabled = serverCfg.isStatisticsEnabled();
        this.addEntryStats = statsLogger.getOpStatsLogger("ADD_ENTRY");
        this.addRequestStats = statsLogger.getOpStatsLogger("ADD_ENTRY_REQUEST");
        this.readEntryStats = statsLogger.getOpStatsLogger("READ_ENTRY");
        this.readRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_REQUEST");
        this.fenceReadEntryStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_READ");
        this.fenceReadRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_REQUEST");
        this.fenceReadWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_FENCE_WAIT");
        this.readEntrySchedulingDelayStats = statsLogger.getOpStatsLogger("READ_ENTRY_SCHEDULING_DELAY");
        this.longPollPreWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_PRE_WAIT");
        this.longPollWaitStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_WAIT");
        this.longPollReadStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_READ");
        this.longPollReadRequestStats = statsLogger.getOpStatsLogger("READ_ENTRY_LONG_POLL_REQUEST");
        this.readLastEntryNoEntryErrorCounter = statsLogger.getCounter("READ_LAST_ENTRY_NOENTRY_ERROR");
        this.writeLacStats = statsLogger.getOpStatsLogger("WRITE_LAC");
        this.writeLacRequestStats = statsLogger.getOpStatsLogger("WRITE_LAC_REQUEST");
        this.readLacStats = statsLogger.getOpStatsLogger("READ_LAC");
        this.readLacRequestStats = statsLogger.getOpStatsLogger("READ_LAC_REQUEST");
        this.getBookieInfoStats = statsLogger.getOpStatsLogger("GET_BOOKIE_INFO");
        this.getBookieInfoRequestStats = statsLogger.getOpStatsLogger("GET_BOOKIE_INFO_REQUEST");
        this.channelWriteStats = statsLogger.getOpStatsLogger("CHANNEL_WRITE");
    }

    @Override
    public void close() {
        this.shutdownExecutor(this.writeThreadPool);
        this.shutdownExecutor(this.readThreadPool);
    }

    private OrderedSafeExecutor createExecutor(int numThreads, String nameFormat) {
        if (numThreads <= 0) {
            return null;
        }
        return OrderedSafeExecutor.newBuilder().numThreads(numThreads).name(nameFormat).build();
    }

    private void shutdownExecutor(OrderedSafeExecutor service) {
        if (null != service) {
            service.shutdown();
        }
    }

    @Override
    public void processRequest(Object msg, Channel c) {
        if (msg instanceof BookkeeperProtocol.Request) {
            BookkeeperProtocol.Request r = (BookkeeperProtocol.Request)msg;
            BookkeeperProtocol.BKPacketHeader header = r.getHeader();
            switch (header.getOperation()) {
                case ADD_ENTRY: {
                    this.processAddRequestV3(r, c);
                    break;
                }
                case READ_ENTRY: {
                    this.processReadRequestV3(r, c);
                    break;
                }
                case AUTH: {
                    LOG.info("Ignoring auth operation from client {}", (Object)c.remoteAddress());
                    BookkeeperProtocol.AuthMessage message = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName("AuthDisabledPlugin").setPayload(ByteString.copyFrom(AuthToken.NULL.getData())).build();
                    BookkeeperProtocol.Response.Builder authResponse = BookkeeperProtocol.Response.newBuilder().setHeader(r.getHeader()).setStatus(BookkeeperProtocol.StatusCode.EOK).setAuthResponse(message);
                    c.writeAndFlush((Object)authResponse.build());
                    break;
                }
                case WRITE_LAC: {
                    this.processWriteLacRequestV3(r, c);
                    break;
                }
                case READ_LAC: {
                    this.processReadLacRequestV3(r, c);
                    break;
                }
                case GET_BOOKIE_INFO: {
                    this.processGetBookieInfoRequestV3(r, c);
                    break;
                }
                case START_TLS: {
                    this.processStartTLSRequestV3(r, c);
                    break;
                }
                default: {
                    LOG.info("Unknown operation type {}", (Object)header.getOperation());
                    BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(r.getHeader()).setStatus(BookkeeperProtocol.StatusCode.EBADREQ);
                    c.writeAndFlush((Object)response.build());
                    if (this.statsEnabled) {
                        this.bkStats.getOpStats(2).incrementFailedOps();
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            BookieProtocol.Request r = (BookieProtocol.Request)msg;
            switch (r.getOpCode()) {
                case 1: {
                    this.processAddRequest(r, c);
                    break;
                }
                case 2: {
                    this.processReadRequest(r, c);
                    break;
                }
                default: {
                    LOG.error("Unknown op type {}, sending error", (Object)r.getOpCode());
                    c.writeAndFlush((Object)ResponseBuilder.buildErrorResponse(100, r));
                    if (!this.statsEnabled) break;
                    this.bkStats.getOpStats(2).incrementFailedOps();
                }
            }
        }
    }

    private void processWriteLacRequestV3(BookkeeperProtocol.Request r, Channel c) {
        WriteLacProcessorV3 writeLac = new WriteLacProcessorV3(r, c, this);
        if (null == this.writeThreadPool) {
            writeLac.run();
        } else {
            this.writeThreadPool.submitOrdered(r.getAddRequest().getLedgerId(), (SafeRunnable)writeLac);
        }
    }

    private void processReadLacRequestV3(BookkeeperProtocol.Request r, Channel c) {
        ReadLacProcessorV3 readLac = new ReadLacProcessorV3(r, c, this);
        if (null == this.readThreadPool) {
            readLac.run();
        } else {
            this.readThreadPool.submitOrdered(r.getAddRequest().getLedgerId(), (SafeRunnable)readLac);
        }
    }

    private void processAddRequestV3(BookkeeperProtocol.Request r, Channel c) {
        WriteEntryProcessorV3 write = new WriteEntryProcessorV3(r, c, this);
        if (null == this.writeThreadPool) {
            write.run();
        } else {
            this.writeThreadPool.submitOrdered(r.getAddRequest().getLedgerId(), (SafeRunnable)write);
        }
    }

    private void processReadRequestV3(BookkeeperProtocol.Request r, Channel c) {
        ListeningScheduledExecutorService lpThreadPool;
        ListeningScheduledExecutorService fenceThreadPool = null == this.readThreadPool ? null : this.readThreadPool.chooseThread(c);
        ListeningScheduledExecutorService listeningScheduledExecutorService = lpThreadPool = null == this.longPollThreadPool ? null : this.longPollThreadPool.chooseThread(c);
        if (RequestUtils.isLongPollReadRequest(r.getReadRequest())) {
            LongPollReadEntryProcessorV3 read = new LongPollReadEntryProcessorV3(r, c, this, fenceThreadPool, lpThreadPool, this.requestTimer);
            if (null == this.longPollThreadPool) {
                read.run();
            } else {
                this.longPollThreadPool.submitOrdered(r.getReadRequest().getLedgerId(), (SafeRunnable)read);
            }
        } else {
            ReadEntryProcessorV3 read = new ReadEntryProcessorV3(r, c, this, fenceThreadPool);
            if (null == this.readThreadPool) {
                read.run();
            } else {
                this.readThreadPool.submitOrdered(r.getReadRequest().getLedgerId(), (SafeRunnable)read);
            }
        }
    }

    private void processStartTLSRequestV3(final BookkeeperProtocol.Request r, final Channel c) {
        BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder();
        BookkeeperProtocol.BKPacketHeader.Builder header = BookkeeperProtocol.BKPacketHeader.newBuilder();
        header.setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
        header.setOperation(r.getHeader().getOperation());
        header.setTxnId(r.getHeader().getTxnId());
        response.setHeader(header.build());
        if (this.shFactory == null) {
            LOG.error("Got StartTLS request but TLS not configured");
            response.setStatus(BookkeeperProtocol.StatusCode.EBADREQ);
            c.writeAndFlush((Object)response.build());
        } else {
            final SslHandler sslHandler = this.shFactory.newTLSHandler();
            c.pipeline().addFirst("tls", (ChannelHandler)sslHandler);
            response.setStatus(BookkeeperProtocol.StatusCode.EOK);
            BookkeeperProtocol.StartTLSResponse.Builder builder = BookkeeperProtocol.StartTLSResponse.newBuilder();
            response.setStartTLSResponse(builder.build());
            sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    AuthHandler.ServerSideHandler authHandler = (AuthHandler.ServerSideHandler)c.pipeline().get(AuthHandler.ServerSideHandler.class);
                    authHandler.authProvider.onProtocolUpgrade();
                    if (future.isSuccess()) {
                        LOG.info("Session is protected by: {}", (Object)sslHandler.engine().getSession().getCipherSuite());
                    } else {
                        LOG.error("TLS Handshake failure: {}", future.cause());
                        BookkeeperProtocol.Response.Builder errResponse = BookkeeperProtocol.Response.newBuilder().setHeader(r.getHeader()).setStatus(BookkeeperProtocol.StatusCode.EIO);
                        c.writeAndFlush((Object)errResponse.build());
                        if (BookieRequestProcessor.this.statsEnabled) {
                            BookieRequestProcessor.this.bkStats.getOpStats(2).incrementFailedOps();
                        }
                    }
                }
            });
            c.writeAndFlush((Object)response.build());
        }
    }

    private void processGetBookieInfoRequestV3(BookkeeperProtocol.Request r, Channel c) {
        GetBookieInfoProcessorV3 getBookieInfo = new GetBookieInfoProcessorV3(r, c, this);
        if (null == this.readThreadPool) {
            getBookieInfo.run();
        } else {
            this.readThreadPool.submit(getBookieInfo);
        }
    }

    private void processAddRequest(BookieProtocol.Request r, Channel c) {
        WriteEntryProcessor write = new WriteEntryProcessor(r, c, this);
        if (null == this.writeThreadPool) {
            write.run();
        } else {
            this.writeThreadPool.submitOrdered(r.getLedgerId(), (SafeRunnable)write);
        }
    }

    private void processReadRequest(BookieProtocol.Request r, Channel c) {
        ReadEntryProcessor read = new ReadEntryProcessor(r, c, this);
        if (null == this.readThreadPool) {
            read.run();
        } else {
            this.readThreadPool.submitOrdered(r.getLedgerId(), (SafeRunnable)read);
        }
    }
}

