/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.twitter.util.Future;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.RequestDeniedException;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.AbstractWriteOp;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.thrift.service.WriteResponse;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class ReleaseOp
extends AbstractWriteOp {
    private final StreamManager streamManager;
    private final Counter deniedReleaseCounter;
    private final AccessControlManager accessControlManager;

    public ReleaseOp(String stream, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, StreamManager streamManager, Long checksum, Feature checksumDisabledFeature, AccessControlManager accessControlManager) {
        super(stream, ReleaseOp.requestStat(statsLogger, "release"), checksum, checksumDisabledFeature);
        StreamOpStats streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.deniedReleaseCounter = streamOpStats.requestDeniedCounter("release");
        this.accessControlManager = accessControlManager;
        this.streamManager = streamManager;
    }

    @Override
    protected Future<WriteResponse> executeOp(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        Future<Void> result = this.streamManager.closeAndRemoveAsync(this.streamName());
        return result.map((Function1)new AbstractFunction1<Void, WriteResponse>(){

            public WriteResponse apply(Void value) {
                return ResponseUtils.writeSuccess();
            }
        });
    }

    @Override
    public void preExecute() throws DLException {
        if (!this.accessControlManager.allowRelease(this.stream)) {
            this.deniedReleaseCounter.inc();
            throw new RequestDeniedException(this.stream, "release");
        }
        super.preExecute();
    }
}

