/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.doclint;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.tools.Diagnostic;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.tools.doclint.Env;
import org.openjdk.tools.javac.util.StringUtils;

public class Messages {
    private final Options options;
    private final Stats stats;
    ResourceBundle bundle;
    Env env;

    Messages(Env env) {
        this.env = env;
        String name = this.getClass().getPackage().getName() + ".resources.doclint";
        this.bundle = ResourceBundle.getBundle(name, Locale.ENGLISH);
        this.stats = new Stats(this.bundle);
        this.options = new Options(this.stats);
    }

    void error(Group group, DocTree tree, String code, Object ... args) {
        this.report(group, Diagnostic.Kind.ERROR, tree, code, args);
    }

    void warning(Group group, DocTree tree, String code, Object ... args) {
        this.report(group, Diagnostic.Kind.WARNING, tree, code, args);
    }

    void setOptions(String opts) {
        this.options.setOptions(opts);
    }

    void setStatsEnabled(boolean b) {
        this.stats.setEnabled(b);
    }

    void reportStats(PrintWriter out) {
        this.stats.report(out);
    }

    protected void report(Group group, Diagnostic.Kind dkind, DocTree tree, String code, Object ... args) {
        if (this.options.isEnabled(group, this.env.currAccess)) {
            String msg = code == null ? (String)args[0] : this.localize(code, args);
            this.env.trees.printMessage(dkind, msg, tree, this.env.currDocComment, this.env.currPath.getCompilationUnit());
            this.stats.record(group, dkind, code);
        }
    }

    protected void report(Group group, Diagnostic.Kind dkind, Tree tree, String code, Object ... args) {
        if (this.options.isEnabled(group, this.env.currAccess)) {
            String msg = this.localize(code, args);
            this.env.trees.printMessage(dkind, msg, tree, this.env.currPath.getCompilationUnit());
            this.stats.record(group, dkind, code);
        }
    }

    String localize(String code, Object ... args) {
        String msg = this.bundle.getString(code);
        if (msg == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("message file broken: code=").append(code);
            if (args.length > 0) {
                sb.append(" arguments={0}");
                for (int i = 1; i < args.length; ++i) {
                    sb.append(", {").append(i).append("}");
                }
            }
            msg = sb.toString();
        }
        return MessageFormat.format(msg, args);
    }

    static class Stats {
        public static final String OPT = "stats";
        public static final String NO_CODE = "";
        final ResourceBundle bundle;
        int[] groupCounts;
        int[] dkindCounts;
        Map<String, Integer> codeCounts;

        Stats(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        void setEnabled(boolean b) {
            if (b) {
                this.groupCounts = new int[Group.values().length];
                this.dkindCounts = new int[Diagnostic.Kind.values().length];
                this.codeCounts = new HashMap<String, Integer>();
            } else {
                this.groupCounts = null;
                this.dkindCounts = null;
                this.codeCounts = null;
            }
        }

        void record(Group g, Diagnostic.Kind dkind, String code) {
            Integer i;
            if (this.codeCounts == null) {
                return;
            }
            int n = g.ordinal();
            this.groupCounts[n] = this.groupCounts[n] + 1;
            int n2 = dkind.ordinal();
            this.dkindCounts[n2] = this.dkindCounts[n2] + 1;
            if (code == null) {
                code = NO_CODE;
            }
            this.codeCounts.put(code, (i = this.codeCounts.get(code)) == null ? 1 : i + 1);
        }

        void report(PrintWriter out) {
            if (this.codeCounts == null) {
                return;
            }
            out.println("By group...");
            Table groupTable = new Table();
            for (Group g : Group.values()) {
                groupTable.put(g.optName(), this.groupCounts[g.ordinal()]);
            }
            groupTable.print(out);
            out.println();
            out.println("By diagnostic kind...");
            Table dkindTable = new Table();
            for (Diagnostic.Kind k : Diagnostic.Kind.values()) {
                dkindTable.put(StringUtils.toLowerCase(k.toString()), this.dkindCounts[k.ordinal()]);
            }
            dkindTable.print(out);
            out.println();
            out.println("By message kind...");
            Table codeTable = new Table();
            for (Map.Entry<String, Integer> e : this.codeCounts.entrySet()) {
                String msg;
                String code = e.getKey();
                try {
                    msg = code.equals(NO_CODE) ? "OTHER" : this.bundle.getString(code);
                }
                catch (MissingResourceException ex) {
                    msg = code;
                }
                codeTable.put(msg, e.getValue());
            }
            codeTable.print(out);
        }

        private static class Table {
            private static final Comparator<Integer> DECREASING = new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            };
            private final TreeMap<Integer, Set<String>> map = new TreeMap(DECREASING);

            private Table() {
            }

            void put(String label, int n) {
                if (n == 0) {
                    return;
                }
                Set<String> labels = this.map.get(n);
                if (labels == null) {
                    labels = new TreeSet<String>();
                    this.map.put(n, labels);
                }
                labels.add(label);
            }

            void print(PrintWriter out) {
                for (Map.Entry<Integer, Set<String>> e : this.map.entrySet()) {
                    int count = e.getKey();
                    Set<String> labels = e.getValue();
                    for (String label : labels) {
                        out.println(String.format("%6d: %s", count, label));
                    }
                }
            }
        }
    }

    static class Options {
        Map<String, Env.AccessKind> map = new HashMap<String, Env.AccessKind>();
        private final Stats stats;
        private static final String ALL = "all";

        static boolean isValidOptions(String opts) {
            for (String opt : opts.split(",")) {
                if (Options.isValidOption(StringUtils.toLowerCase(opt.trim()))) continue;
                return false;
            }
            return true;
        }

        private static boolean isValidOption(String opt) {
            if (opt.equals("none") || opt.equals("stats")) {
                return true;
            }
            int begin = opt.startsWith("-") ? 1 : 0;
            int sep = opt.indexOf("/");
            String grp = opt.substring(begin, sep != -1 ? sep : opt.length());
            return (begin == 0 && grp.equals(ALL) || Group.accepts(grp)) && (sep == -1 || Env.AccessKind.accepts(opt.substring(sep + 1)));
        }

        Options(Stats stats) {
            this.stats = stats;
        }

        boolean isEnabled(Group g, Env.AccessKind access) {
            Env.AccessKind ak;
            if (this.map.isEmpty()) {
                this.map.put(ALL, Env.AccessKind.PROTECTED);
            }
            if ((ak = this.map.get(g.optName())) != null && access.compareTo(ak) >= 0) {
                return true;
            }
            ak = this.map.get(ALL);
            return ak != null && access.compareTo(ak) >= 0 && ((ak = this.map.get(g.notOptName())) == null || access.compareTo(ak) > 0);
        }

        void setOptions(String opts) {
            if (opts == null) {
                this.setOption(ALL, Env.AccessKind.PRIVATE);
            } else {
                for (String opt : opts.split(",")) {
                    this.setOption(StringUtils.toLowerCase(opt.trim()));
                }
            }
        }

        private void setOption(String arg) throws IllegalArgumentException {
            if (arg.equals("stats")) {
                this.stats.setEnabled(true);
                return;
            }
            int sep = arg.indexOf("/");
            if (sep > 0) {
                Env.AccessKind ak = Env.AccessKind.valueOf(StringUtils.toUpperCase(arg.substring(sep + 1)));
                this.setOption(arg.substring(0, sep), ak);
            } else {
                this.setOption(arg, null);
            }
        }

        private void setOption(String opt, Env.AccessKind ak) {
            this.map.put(opt, ak != null ? ak : (opt.startsWith("-") ? Env.AccessKind.PUBLIC : Env.AccessKind.PRIVATE));
        }
    }

    public static enum Group {
        ACCESSIBILITY,
        HTML,
        MISSING,
        SYNTAX,
        REFERENCE;


        String optName() {
            return StringUtils.toLowerCase(this.name());
        }

        String notOptName() {
            return "-" + this.optName();
        }

        static boolean accepts(String opt) {
            for (Group g : Group.values()) {
                if (!opt.equals(g.optName())) continue;
                return true;
            }
            return false;
        }
    }
}

