/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.tool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class EditPad
extends JFrame
implements Runnable {
    private final Consumer<String> errorHandler;
    private final String initialText;
    private final CountDownLatch closeLock;
    private final Consumer<String> saveHandler;

    EditPad(Consumer<String> errorHandler, String initialText, CountDownLatch closeLock, Consumer<String> saveHandler) {
        super("JShell Edit Pad");
        this.errorHandler = errorHandler;
        this.initialText = initialText;
        this.closeLock = closeLock;
        this.saveHandler = saveHandler;
    }

    @Override
    public void run() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditPad.this.dispose();
                EditPad.this.closeLock.countDown();
            }
        });
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(this.initialText);
        this.add((Component)new JScrollPane(textArea), "Center");
        this.add((Component)this.buttons(textArea), "South");
        this.setSize(800, 600);
        this.setVisible(true);
    }

    private JPanel buttons(JTextArea textArea) {
        FlowLayout flow = new FlowLayout();
        flow.setHgap(35);
        JPanel buttons = new JPanel(flow);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic(67);
        JButton accept = new JButton("Accept");
        accept.setMnemonic(65);
        JButton exit = new JButton("Exit");
        exit.setMnemonic(88);
        buttons.add(cancel);
        buttons.add(accept);
        buttons.add(exit);
        cancel.addActionListener(e -> this.close());
        accept.addActionListener(e -> this.saveHandler.accept(textArea.getText()));
        exit.addActionListener(e -> {
            this.saveHandler.accept(textArea.getText());
            this.close();
        });
        return buttons;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.closeLock.countDown();
    }

    public static void edit(Consumer<String> errorHandler, String initialText, Consumer<String> saveHandler) {
        CountDownLatch closeLock = new CountDownLatch(1);
        SwingUtilities.invokeLater(new EditPad(errorHandler, initialText, closeLock, saveHandler));
        while (true) {
            try {
                closeLock.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

