/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import com.twitter.common.util.Random;

public class Sampler {
    private final Random rand;
    private final double threshold;

    public Sampler(float selectPercent) {
        this(selectPercent, Random.Util.newDefaultRandom());
    }

    public Sampler(float selectPercent, Random rand) {
        Preconditions.checkArgument((selectPercent >= 0.0f && selectPercent <= 100.0f ? 1 : 0) != 0, (Object)("Invalid selectPercent value: " + selectPercent));
        this.threshold = selectPercent / 100.0f;
        this.rand = (Random)Preconditions.checkNotNull((Object)rand);
    }

    public boolean select() {
        return this.rand.nextDouble() < this.threshold;
    }
}

