/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.collect.ImmutableSet;
import com.twitter.common.base.Command;
import com.twitter.common.base.Commands;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.zookeeper.Group;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.Addr;
import com.twitter.finagle.Address;
import com.twitter.finagle.Name;
import com.twitter.finagle.Resolver$;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import com.twitter.thrift.Status;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.distributedlog.client.routing.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

class NameServerSet
implements ServerSet {
    private static final Logger logger = LoggerFactory.getLogger(NameServerSet.class);
    private volatile Set<DynamicHostSet.HostChangeMonitor<ServiceInstance>> watchers = new HashSet<DynamicHostSet.HostChangeMonitor<ServiceInstance>>();
    private volatile ImmutableSet<ServiceInstance> hostSet = ImmutableSet.of();
    private AtomicBoolean resolutionPending = new AtomicBoolean(true);

    public NameServerSet(String nameStr) {
        Name name;
        try {
            name = Resolver$.MODULE$.eval(nameStr);
        }
        catch (Exception exc) {
            logger.error("Exception in Resolver.eval for name {}", (Object)nameStr, (Object)exc);
            throw new RuntimeException(exc);
        }
        this.initialize(name);
    }

    public NameServerSet(Name name) {
        this.initialize(name);
    }

    private void initialize(Name name) {
        if (name instanceof TestName) {
            ((TestName)name).changes(new AbstractFunction1<Addr, BoxedUnit>(){

                public BoxedUnit apply(Addr varAddr) {
                    return NameServerSet.this.respondToChanges(varAddr);
                }
            });
        } else if (name instanceof Name.Bound) {
            ((Name.Bound)name).addr().changes().respond((Function1)new AbstractFunction1<Addr, BoxedUnit>(){

                public BoxedUnit apply(Addr varAddr) {
                    return NameServerSet.this.respondToChanges(varAddr);
                }
            });
        } else {
            logger.error("NameServerSet only supports Name.Bound. While the resolved name {} was {}", (Object)name, name.getClass());
            throw new UnsupportedOperationException("NameServerSet only supports Name.Bound");
        }
    }

    private ServiceInstance endpointAddressToServiceInstance(Address endpointAddress) {
        if (endpointAddress instanceof Address.Inet) {
            InetSocketAddress inetSocketAddress = ((Address.Inet)endpointAddress).addr();
            Endpoint endpoint = new Endpoint(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            HashMap<String, Endpoint> map = new HashMap<String, Endpoint>();
            map.put("thrift", endpoint);
            return new ServiceInstance(endpoint, map, Status.ALIVE);
        }
        logger.error("We expect InetSocketAddress while the resolved address {} was {}", (Object)endpointAddress, endpointAddress.getClass());
        throw new UnsupportedOperationException("invalid endpoint address: " + endpointAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoxedUnit respondToChanges(Addr addr) {
        ImmutableSet oldHostSet;
        ImmutableSet newHostSet = oldHostSet = ImmutableSet.copyOf(this.hostSet);
        if (addr instanceof Addr.Bound) {
            scala.collection.immutable.Set endpointAddresses = ((Addr.Bound)addr).addrs();
            Iterator endpointAddressesIterator = endpointAddresses.toIterator();
            HashSet<ServiceInstance> serviceInstances = new HashSet<ServiceInstance>();
            while (endpointAddressesIterator.hasNext()) {
                serviceInstances.add(this.endpointAddressToServiceInstance((Address)endpointAddressesIterator.next()));
            }
            newHostSet = ImmutableSet.copyOf(serviceInstances);
        } else if (addr instanceof Addr.Failed) {
            logger.error("Name resolution failed", ((Addr.Failed)addr).cause());
            newHostSet = ImmutableSet.of();
        } else if (addr.toString().equals("Pending")) {
            logger.info("Name resolution pending");
            newHostSet = oldHostSet;
        } else if (addr.toString().equals("Neg")) {
            newHostSet = ImmutableSet.of();
        } else {
            logger.error("Invalid Addr type: {}", (Object)addr.getClass().getName());
            throw new UnsupportedOperationException("Invalid Addr type:" + addr.getClass().getName());
        }
        if (oldHostSet != newHostSet) {
            logger.info("NameServerSet updated: {} -> {}", (Object)this.hostSetToString((ImmutableSet<ServiceInstance>)oldHostSet), (Object)this.hostSetToString((ImmutableSet<ServiceInstance>)newHostSet));
            this.resolutionPending.set(false);
            this.hostSet = newHostSet;
            Set<DynamicHostSet.HostChangeMonitor<ServiceInstance>> set = this.watchers;
            synchronized (set) {
                for (DynamicHostSet.HostChangeMonitor<ServiceInstance> watcher : this.watchers) {
                    watcher.onChange(newHostSet);
                }
            }
        }
        return BoxedUnit.UNIT;
    }

    private String hostSetToString(ImmutableSet<ServiceInstance> hostSet) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        for (ServiceInstance serviceInstance : hostSet) {
            Endpoint endpoint = serviceInstance.getServiceEndpoint();
            result.append(String.format(" %s:%d", endpoint.getHost(), endpoint.getPort()));
        }
        result.append(" )");
        return result.toString();
    }

    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, Status status) throws Group.JoinException, InterruptedException {
        throw new UnsupportedOperationException("NameServerSet does not support join");
    }

    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints) throws Group.JoinException, InterruptedException {
        throw new UnsupportedOperationException("NameServerSet does not support join");
    }

    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> additionalEndpoints, int shardId) throws Group.JoinException, InterruptedException {
        throw new UnsupportedOperationException("NameServerSet does not support join");
    }

    @Deprecated
    public void monitor(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        throw new UnsupportedOperationException("NameServerSet does not support monitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command watch(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        Set<DynamicHostSet.HostChangeMonitor<ServiceInstance>> set = this.watchers;
        synchronized (set) {
            this.watchers.add(monitor);
        }
        if (this.resolutionPending.compareAndSet(false, false)) {
            monitor.onChange(this.hostSet);
        }
        return Commands.NOOP;
    }
}

