/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.bookkeeper.bookie.ShortReadException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPersistenceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(IndexPersistenceMgr.class);
    private static final String IDX = ".idx";
    static final String RLOC = ".rloc";
    final ConcurrentMap<Long, FileInfo> fileInfoCache = new ConcurrentHashMap<Long, FileInfo>();
    final int openFileLimit;
    final int pageSize;
    final int entriesPerPage;
    final SnapshotMap<Long, Boolean> activeLedgers;
    private LedgerDirsManager ledgerDirsManager;
    final LinkedList<Long> openLedgers = new LinkedList();
    private final Counter evictedLedgersCounter;

    @VisibleForTesting
    public static final String getLedgerName(long ledgerId) {
        int parent = (int)(ledgerId & 0xFFL);
        int grandParent = (int)((ledgerId & 0xFF00L) >> 8);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(grandParent));
        sb.append('/');
        sb.append(Integer.toHexString(parent));
        sb.append('/');
        sb.append(Long.toHexString(ledgerId));
        sb.append(IDX);
        return sb.toString();
    }

    public IndexPersistenceMgr(int pageSize, int entriesPerPage, ServerConfiguration conf, SnapshotMap<Long, Boolean> activeLedgers, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger) throws IOException {
        this.openFileLimit = conf.getOpenFileLimit();
        this.activeLedgers = activeLedgers;
        this.ledgerDirsManager = ledgerDirsManager;
        this.pageSize = pageSize;
        this.entriesPerPage = entriesPerPage;
        LOG.info("openFileLimit = {}", (Object)this.openFileLimit);
        this.getActiveLedgers();
        ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        this.evictedLedgersCounter = statsLogger.getCounter("LEDGER_CACHE_NUM_EVICTED_LEDGERS");
        statsLogger.registerGauge("NUM_OPEN_LEDGERS", (Gauge)new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return IndexPersistenceMgr.this.getNumOpenLedgers();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileInfo getFileInfo(Long ledger, byte[] masterKey) throws IOException {
        FileInfo fi = (FileInfo)this.fileInfoCache.get(ledger);
        if (null == fi) {
            boolean createdNewFile = false;
            File lf = null;
            IndexPersistenceMgr indexPersistenceMgr = this;
            synchronized (indexPersistenceMgr) {
                lf = this.findIndexFile(ledger);
                if (null == lf) {
                    if (null == masterKey) {
                        throw new Bookie.NoLedgerException(ledger);
                    }
                    lf = this.getNewLedgerIndexFile(ledger, null);
                    createdNewFile = true;
                }
            }
            fi = this.putFileInfo(ledger, masterKey, lf, createdNewFile);
        }
        assert (null != fi);
        fi.use();
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo putFileInfo(Long ledger, byte[] masterKey, File lf, boolean createdNewFile) throws IOException {
        FileInfo fi = new FileInfo(lf, masterKey);
        FileInfo oldFi = this.fileInfoCache.putIfAbsent(ledger, fi);
        if (null != oldFi) {
            if (createdNewFile && !oldFi.isSameFile(lf)) {
                fi.delete();
            }
            fi = oldFi;
        } else {
            if (createdNewFile) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New ledger index file created for ledgerId: {}", (Object)ledger);
                }
                this.activeLedgers.put(ledger, true);
            }
            this.evictFileInfoIfNecessary();
            LinkedList<Long> linkedList = this.openLedgers;
            synchronized (linkedList) {
                this.openLedgers.offer(ledger);
            }
        }
        return fi;
    }

    private File getNewLedgerIndexFile(Long ledger, File excludedDir) throws LedgerDirsManager.NoWritableLedgerDirException {
        File dir = this.ledgerDirsManager.pickRandomWritableDirForNewIndexFile(excludedDir);
        String ledgerName = IndexPersistenceMgr.getLedgerName(ledger);
        return new File(dir, ledgerName);
    }

    private void getActiveLedgers() throws IOException {
        for (File ledgerDirectory : this.ledgerDirsManager.getAllLedgerDirs()) {
            File[] grandParents = ledgerDirectory.listFiles();
            if (grandParents == null) continue;
            for (File grandParent : grandParents) {
                File[] parents;
                if (!grandParent.isDirectory() || (parents = grandParent.listFiles()) == null) continue;
                for (File parent : parents) {
                    File[] indexFiles;
                    if (!parent.isDirectory() || (indexFiles = parent.listFiles()) == null) continue;
                    for (File index : indexFiles) {
                        if (!index.isFile() || !index.getName().endsWith(IDX) && !index.getName().endsWith(RLOC)) continue;
                        String ledgerIdInHex = index.getName().replace(RLOC, "").replace(IDX, "");
                        if (index.getName().endsWith(RLOC)) {
                            if (this.findIndexFile(Long.parseLong(ledgerIdInHex)) != null) {
                                if (index.delete()) continue;
                                LOG.warn("Deleting the rloc file " + index + " failed");
                                continue;
                            }
                            File dest = new File(index.getParentFile(), ledgerIdInHex + IDX);
                            if (!index.renameTo(dest)) {
                                throw new IOException("Renaming rloc file " + index + " to index file has failed");
                            }
                        }
                        this.activeLedgers.put(Long.parseLong(ledgerIdInHex, 16), true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLedger(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.close(false);
            fi.delete();
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
        this.activeLedgers.remove(ledgerId);
        this.fileInfoCache.remove(ledgerId);
        LinkedList<Long> linkedList = this.openLedgers;
        synchronized (linkedList) {
            this.openLedgers.remove(ledgerId);
        }
    }

    private File findIndexFile(long ledgerId) throws IOException {
        String ledgerName = IndexPersistenceMgr.getLedgerName(ledgerId);
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File lf = new File(d, ledgerName);
            if (!lf.exists()) continue;
            return lf;
        }
        return null;
    }

    boolean ledgerExists(long ledgerId) throws IOException {
        return this.activeLedgers.containsKey(ledgerId);
    }

    int getNumOpenLedgers() {
        return this.openLedgers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictFileInfoIfNecessary() throws IOException {
        if (this.openLedgers.size() > this.openFileLimit) {
            Long ledgerToRemove;
            LinkedList<Long> linkedList = this.openLedgers;
            synchronized (linkedList) {
                ledgerToRemove = this.openLedgers.poll();
            }
            if (null == ledgerToRemove) {
                return;
            }
            this.evictedLedgersCounter.inc();
            FileInfo fi = (FileInfo)this.fileInfoCache.remove(ledgerToRemove);
            if (null == fi) {
                return;
            }
            fi.close(true);
        }
    }

    void close() throws IOException {
        for (Map.Entry fileInfo : this.fileInfoCache.entrySet()) {
            FileInfo value = (FileInfo)fileInfo.getValue();
            if (value == null) continue;
            value.close(true);
        }
        this.fileInfoCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long getLastAddConfirmed(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            Long l = fi.getLastAddConfirmed();
            return l;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Observable waitForLastAddConfirmedUpdate(long ledgerId, long previoisLAC, Observer observer) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            Observable observable = fi.waitForLastAddConfirmedUpdate(previoisLAC, observer);
            return observable;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateLastAddConfirmed(long ledgerId, long lac) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            long l = fi.setLastAddConfirmed(lac);
            return l;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        FileInfo fi = (FileInfo)this.fileInfoCache.get(ledgerId);
        if (fi == null) {
            File lf = this.findIndexFile(ledgerId);
            if (lf == null) {
                throw new Bookie.NoLedgerException(ledgerId);
            }
            fi = this.putFileInfo(ledgerId, null, lf, false);
        }
        return fi.getMasterKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, masterKey);
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFenced(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            boolean bl = fi.setFenced();
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFenced(long ledgerId) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            boolean bl = fi.isFenced();
            return bl;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            fi.setExplicitLac(lac);
            return;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getExplicitLac(long ledgerId) {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledgerId, null);
            ByteBuf byteBuf = fi.getExplicitLac();
            return byteBuf;
        }
        catch (IOException e) {
            LOG.error("Exception during getLastAddConfirmed: {}", (Throwable)e);
            ByteBuf byteBuf = null;
            return byteBuf;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    int getOpenFileLimit() {
        return this.openFileLimit;
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskFull(File disk) {
            }

            @Override
            public void diskAlmostFull(File disk) {
            }

            @Override
            public void diskFailed(File disk) {
            }

            @Override
            public void allDisksFull() {
            }

            @Override
            public void fatalError() {
            }

            @Override
            public void diskWritable(File disk) {
            }

            @Override
            public void diskJustWritable(File disk) {
            }
        };
    }

    private void relocateIndexFileAndFlushHeader(long ledger, FileInfo fi) throws IOException {
        File currentDir = this.getLedgerDirForLedger(fi);
        if (this.ledgerDirsManager.isDirFull(currentDir)) {
            this.moveLedgerIndexFile(ledger, fi);
        }
        fi.flushHeader();
    }

    private File getLedgerDirForLedger(FileInfo fi) {
        return fi.getLf().getParentFile().getParentFile().getParentFile();
    }

    private void moveLedgerIndexFile(Long l, FileInfo fi) throws LedgerDirsManager.NoWritableLedgerDirException, IOException {
        File newLedgerIndexFile = this.getNewLedgerIndexFile(l, this.getLedgerDirForLedger(fi));
        fi.moveToNewLocation(newLedgerIndexFile, fi.getSizeSinceLastwrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLedgerHeader(long ledger) throws IOException {
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(ledger, null);
            this.relocateIndexFileAndFlushHeader(ledger, fi);
        }
        catch (Bookie.NoLedgerException nle) {
            LOG.info("No ledger {} found when flushing header.", (Object)ledger);
            return;
        }
        finally {
            if (null != fi) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLedgerEntries(long l, List<LedgerEntryPage> entries) throws IOException {
        FileInfo fi = null;
        try {
            int i;
            Collections.sort(entries, new Comparator<LedgerEntryPage>(){

                @Override
                public int compare(LedgerEntryPage o1, LedgerEntryPage o2) {
                    return (int)(o1.getFirstEntry() - o2.getFirstEntry());
                }
            });
            int[] versions = new int[entries.size()];
            try {
                fi = this.getFileInfo(l, null);
            }
            catch (Bookie.NoLedgerException nle) {
                LOG.info("No ledger {} found when flushing entries.", (Object)l);
                if (fi != null) {
                    fi.release();
                }
                return;
            }
            this.relocateIndexFileAndFlushHeader(l, fi);
            int start = 0;
            long lastOffset = -1L;
            for (i = 0; i < entries.size(); ++i) {
                versions[i] = entries.get(i).getVersion();
                if (lastOffset != -1L && entries.get(i).getFirstEntry() - lastOffset != (long)this.entriesPerPage) {
                    int count = i - start;
                    if (count == 0) {
                        LOG.warn("Count cannot possibly be zero!");
                    }
                    this.writeBuffers(l, entries, fi, start, count);
                    start = i;
                }
                lastOffset = entries.get(i).getFirstEntry();
            }
            if (entries.size() - start == 0 && entries.size() != 0) {
                LOG.warn("Nothing to write, but there were entries!");
            }
            this.writeBuffers(l, entries, fi, start, entries.size() - start);
            for (i = 0; i < entries.size(); ++i) {
                LedgerEntryPage lep = entries.get(i);
                lep.setClean(versions[i]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed ledger {} with {} pages.", (Object)l, (Object)entries.size());
            }
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    private void writeBuffers(Long ledger, List<LedgerEntryPage> entries, FileInfo fi, int start, int count) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing {} buffers of {}", (Object)count, (Object)Long.toHexString(ledger));
        }
        if (count == 0) {
            return;
        }
        ByteBuffer[] buffs = new ByteBuffer[count];
        for (int j = 0; j < count; ++j) {
            buffs[j] = entries.get(start + j).getPageToWrite();
            if (entries.get(start + j).getLedger() == ledger.longValue()) continue;
            throw new IOException("Writing to " + ledger + " but page belongs to " + entries.get(start + j).getLedger());
        }
        long totalWritten = 0L;
        while (buffs[buffs.length - 1].remaining() > 0) {
            long rc = fi.write(buffs, entries.get(start + 0).getFirstEntryPosition());
            if (rc <= 0L) {
                throw new IOException("Short write to ledger " + ledger + " rc = " + rc);
            }
            totalWritten += rc;
        }
        if (totalWritten != (long)count * (long)this.pageSize) {
            throw new IOException("Short write to ledger " + ledger + " wrote " + totalWritten + " expected " + count * this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updatePage(LedgerEntryPage lep) throws IOException {
        if (!lep.isClean()) {
            throw new IOException("Trying to update a dirty page");
        }
        FileInfo fi = null;
        try {
            fi = this.getFileInfo(lep.getLedger(), null);
            long pos = lep.getFirstEntryPosition();
            if (pos >= fi.size()) {
                lep.zeroPage();
                boolean bl = true;
                return bl;
            }
            lep.readPage(fi);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fi != null) {
                fi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPersistEntryBeyondInMem(long ledgerId, long lastEntryInMem) throws IOException {
        long lastEntry;
        block10: {
            FileInfo fi = null;
            lastEntry = lastEntryInMem;
            try {
                fi = this.getFileInfo(ledgerId, null);
                long size = fi.size();
                if (0L != size % (long)LedgerEntryPage.getIndexEntrySize()) {
                    LOG.warn("Index file of ledger {} is not aligned with index entry size.", (Object)ledgerId);
                    size -= size % (long)LedgerEntryPage.getIndexEntrySize();
                }
                if (size <= lastEntry * (long)LedgerEntryPage.getIndexEntrySize()) break block10;
                ByteBuffer bb = ByteBuffer.allocate(this.pageSize);
                long position = size - (long)this.pageSize;
                if (position < 0L) {
                    position = 0L;
                }
                try {
                    fi.read(bb, position, false);
                }
                catch (ShortReadException sre) {
                    throw new ShortReadException("Short read on ledger " + ledgerId + " : ", sre);
                }
                bb.flip();
                long startingEntryId = position / (long)LedgerEntryPage.getIndexEntrySize();
                for (int i = this.entriesPerPage - 1; i >= 0; --i) {
                    if (bb.getLong(i * LedgerEntryPage.getIndexEntrySize()) == 0L) continue;
                    if (lastEntry < startingEntryId + (long)i) {
                        lastEntry = startingEntryId + (long)i;
                    }
                    break;
                }
            }
            finally {
                if (fi != null) {
                    fi.release();
                }
            }
        }
        return lastEntry;
    }
}

