/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DigestManager;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TryReadLastConfirmedOp
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    static final Logger LOG = LoggerFactory.getLogger(TryReadLastConfirmedOp.class);
    final LedgerHandle lh;
    final ReadLastConfirmedOp.LastConfirmedDataCallback cb;
    int numResponsesPending;
    volatile boolean hasValidResponse = false;
    volatile boolean completed = false;
    DigestManager.RecoveryData maxRecoveredData;

    TryReadLastConfirmedOp(LedgerHandle lh, ReadLastConfirmedOp.LastConfirmedDataCallback cb, long lac) {
        this.lh = lh;
        this.cb = cb;
        this.maxRecoveredData = new DigestManager.RecoveryData(lac, 0L);
        this.numResponsesPending = lh.metadata.getEnsembleSize();
    }

    public void initiate() {
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.bookieClient.readEntry(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i);
        }
    }

    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("TryReadLastConfirmed received response for (lid={}, eid={}) : {}", new Object[]{ledgerId, entryId, rc});
        }
        int bookieIndex = (Integer)ctx;
        --this.numResponsesPending;
        if (0 == rc) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received lastAddConfirmed (lac={}, length={}) from bookie({}) for (lid={}).", new Object[]{recoveryData.lastAddConfirmed, recoveryData.length, bookieIndex, ledgerId});
                }
                if (recoveryData.lastAddConfirmed > this.maxRecoveredData.lastAddConfirmed) {
                    this.maxRecoveredData = recoveryData;
                    this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
                }
                this.hasValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch for ledger: " + ledgerId + ", entry: " + entryId + " while reading last entry from bookie: " + this.lh.metadata.currentEnsemble.get(bookieIndex));
            }
        } else if (-102 == rc && !this.completed) {
            this.cb.readLastConfirmedDataComplete(rc, this.maxRecoveredData);
            this.completed = true;
        } else if (-7 == rc || -13 == rc) {
            this.hasValidResponse = true;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            if (!this.hasValidResponse) {
                this.cb.readLastConfirmedDataComplete(-10, this.maxRecoveredData);
            } else {
                this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
            }
            this.completed = true;
        }
    }
}

