/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import bk-shade.com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadEntryProcessor
extends PacketProcessorBase {
    private static final Logger LOG = LoggerFactory.getLogger(ReadEntryProcessor.class);

    public ReadEntryProcessor(BookieProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    @Override
    protected void processPacket() {
        ByteBuf data;
        long startTimeNanos;
        int errorCode;
        BookieProtocol.ReadRequest read;
        block23: {
            assert (this.request instanceof BookieProtocol.ReadRequest);
            read = (BookieProtocol.ReadRequest)this.request;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received new read request: {}", (Object)this.request);
            }
            errorCode = 101;
            startTimeNanos = MathUtils.nowInNano();
            data = null;
            try {
                SettableFuture<Boolean> fenceResult = null;
                if (read.isFencingRequest()) {
                    LOG.warn("Ledger: {}  fenced by: {}", (Object)this.request.getLedgerId(), (Object)this.channel.remoteAddress());
                    if (read.hasMasterKey()) {
                        fenceResult = this.requestProcessor.bookie.fenceLedger(read.getLedgerId(), read.getMasterKey());
                    } else {
                        LOG.error("Password not provided, Not safe to fence {}", (Object)read.getLedgerId());
                        throw BookieException.create(-1);
                    }
                }
                data = this.requestProcessor.bookie.readEntry(this.request.getLedgerId(), this.request.getEntryId());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("##### Read entry ##### {} -- ref-count: {}", (Object)data.readableBytes(), (Object)data.refCnt());
                }
                if (null != fenceResult) {
                    try {
                        Boolean fenced = (Boolean)fenceResult.get(1000L, TimeUnit.MILLISECONDS);
                        if (null == fenced || !fenced.booleanValue()) {
                            errorCode = 101;
                            data = null;
                            break block23;
                        }
                        errorCode = 0;
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Interrupting fence read entry " + read, (Throwable)ie);
                        errorCode = 101;
                        data = null;
                    }
                    catch (ExecutionException ee) {
                        LOG.error("Failed to fence read entry " + read, (Throwable)ee);
                        errorCode = 101;
                        data = null;
                    }
                    catch (TimeoutException te) {
                        LOG.error("Timeout to fence read entry " + read, (Throwable)te);
                        errorCode = 101;
                        data = null;
                    }
                    break block23;
                }
                errorCode = 0;
            }
            catch (Bookie.NoLedgerException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.error("Error reading " + read, (Throwable)e);
                }
                errorCode = 1;
            }
            catch (Bookie.NoEntryException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.error("Error reading " + read, (Throwable)e);
                }
                errorCode = 2;
            }
            catch (IOException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.error("Error reading " + read, (Throwable)e);
                }
                errorCode = 101;
            }
            catch (BookieException e) {
                LOG.error("Unauthorized access to ledger " + read.getLedgerId(), (Throwable)e);
                errorCode = 102;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Read entry rc = {} for {}", new Object[]{errorCode, read});
        }
        if (errorCode == 0) {
            this.requestProcessor.readEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(errorCode, ResponseBuilder.buildReadResponse(data, read), this.requestProcessor.readRequestStats);
        } else {
            ReferenceCountUtil.release(data);
            this.requestProcessor.readEntryStats.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(errorCode, ResponseBuilder.buildErrorResponse(errorCode, read), this.requestProcessor.readRequestStats);
        }
    }

    public String toString() {
        return String.format("ReadEntry(%d, %d)", this.request.getLedgerId(), this.request.getEntryId());
    }
}

