/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.util.Date;
import java.util.Random;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.bookkeeper.sasl.JAASCredentialsContainer;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.Shell;
import org.apache.zookeeper.common.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TGTRefreshThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(TGTRefreshThread.class);
    private static final Random rng = new Random();
    private long lastLogin;
    private final JAASCredentialsContainer container;
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final float TICKET_RENEW_JITTER = 0.05f;
    private static final long MIN_TIME_BEFORE_RELOGIN = 60000L;

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public TGTRefreshThread(JAASCredentialsContainer container) {
        this.container = container;
        this.lastLogin = System.currentTimeMillis() - 60000L;
        this.setDaemon(true);
        this.setName("bookkeeper-tgt-refresh-thread");
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.container.getSubject().getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Client principal is \"" + ticket.getClient().getName() + "\".");
                LOG.debug("Server principal is \"" + ticket.getServer().getName() + "\".");
            }
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        LOG.info("TGT valid starting at:        {}", (Object)tgt.getStartTime().toString());
        LOG.info("TGT expires:                  {}", (Object)tgt.getEndTime().toString());
        long proposedRefresh = start + (long)((double)(expires - start) * ((double)0.8f + (double)0.05f * rng.nextDouble()));
        if (proposedRefresh > expires) {
            return Time.currentWallTime();
        }
        return proposedRefresh;
    }

    @Override
    public void run() {
        LOG.info("TGT refresh thread started.");
        block12: while (true) {
            block29: {
                Date nextRefreshDate;
                long nextRefresh;
                KerberosTicket tgt = this.getTGT();
                long now = Time.currentWallTime();
                if (tgt == null) {
                    nextRefresh = now + 60000L;
                    nextRefreshDate = new Date(nextRefresh);
                    LOG.warn("No TGT found: will try again at {}", (Object)nextRefreshDate);
                } else {
                    Object[] logPayload;
                    nextRefresh = this.getRefreshTime(tgt);
                    long expiry = tgt.getEndTime().getTime();
                    Date expiryDate = new Date(expiry);
                    if (this.container.isUsingTicketCache() && tgt.getEndTime().equals(tgt.getRenewTill())) {
                        logPayload = new Object[]{expiryDate, this.container.getPrincipal(), this.container.getPrincipal()};
                        LOG.error("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be authenticate a new connection with a Bookie ).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {}' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", logPayload);
                        return;
                    }
                    if (nextRefresh > expiry || now + 60000L > expiry) {
                        nextRefresh = now;
                    } else {
                        if (nextRefresh < now + 60000L) {
                            Date until = new Date(nextRefresh);
                            Date newuntil = new Date(now + 60000L);
                            Object[] logPayload2 = new Object[]{until, newuntil, 60L};
                            LOG.warn("TGT refresh thread time adjusted from : {} to : {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", logPayload2);
                        }
                        nextRefresh = Math.max(nextRefresh, now + 60000L);
                    }
                    nextRefreshDate = new Date(nextRefresh);
                    if (nextRefresh > expiry) {
                        logPayload = new Object[]{nextRefreshDate, expiryDate};
                        LOG.error("next refresh: {} is later than expiry {}. This may indicate a clock skew problem.Check that this host and the KDC's hosts' clocks are in sync. Exiting refresh thread.", logPayload);
                        return;
                    }
                }
                if (now == nextRefresh) {
                    LOG.info("refreshing now because expiry is before next scheduled refresh time.");
                } else {
                    if (now < nextRefresh) {
                        Date until = new Date(nextRefresh);
                        LOG.info("TGT refresh sleeping until: {}", (Object)until.toString());
                        try {
                            Thread.sleep(nextRefresh - now);
                            break block29;
                        }
                        catch (InterruptedException ie) {
                            LOG.warn("TGT renewal thread has been interrupted and will exit.");
                            break;
                        }
                    }
                    LOG.error("nextRefresh:{} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)nextRefreshDate);
                    break;
                }
            }
            if (this.container.isUsingTicketCache()) {
                String cmd = this.container.getConfiguration().getString("kerberos.kinit", "/usr/bin/kinit");
                String kinitArgs = "-R";
                for (int retry = 1; retry >= 0; --retry) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("running ticket cache refresh command: {} {}", (Object)cmd, (Object)kinitArgs);
                        }
                        Shell.execCommand((String[])new String[]{cmd, kinitArgs});
                        break;
                    }
                    catch (Exception e) {
                        if (retry > 0) {
                            try {
                                Thread.sleep(10000L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                LOG.error("Interrupted while renewing TGT, exiting Login thread");
                                return;
                            }
                        }
                        Object[] logPayload = new Object[]{cmd, kinitArgs, e.toString(), e};
                        LOG.warn("Could not renew TGT due to problem running shell command: '{} {}'; exception was:{}. Exiting refresh thread.", logPayload);
                        return;
                    }
                }
            }
            try {
                int retry = 1;
                while (true) {
                    if (retry < 0) continue block12;
                    try {
                        this.reLogin();
                        continue block12;
                    }
                    catch (LoginException le) {
                        if (retry > 0) {
                            --retry;
                            try {
                                Thread.sleep(10000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                LOG.error("Interrupted during login retry after LoginException:", (Throwable)le);
                                throw le;
                            }
                        }
                        LOG.error("Could not refresh TGT for principal: {}.", (Object)this.container.getPrincipal(), (Object)le);
                        continue;
                    }
                    break;
                }
            }
            catch (LoginException le) {
                LOG.error("Failed to refresh TGT: refresh thread exiting now.", (Throwable)le);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        LoginContext login = this.container.getLogin();
        if (login == null) {
            throw new LoginException("login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        LOG.info("Initiating logout for {}", (Object)this.container.getPrincipal());
        Class<Login> clazz = Login.class;
        synchronized (Login.class) {
            login.logout();
            login = new LoginContext(this.container.getLoginContextName(), this.container.getSubject());
            LOG.info("Initiating re-login for {}", (Object)this.container.getPrincipal());
            login.login();
            this.container.setLogin(login);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean hasSufficientTimeElapsed() {
        long now = System.currentTimeMillis();
        if (now - this.getLastLogin() < 60000L) {
            LOG.warn("Not attempting to re-login since the last re-login was attempted less than {} seconds before.", (Object)60L);
            return false;
        }
        this.setLastLogin(now);
        return true;
    }
}

