/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationConfigMap
extends AbstractConfigMapImpl<Location> {
    private static final Logger log = LoggerFactory.getLogger(LocationConfigMap.class);

    public LocationConfigMap(AbstractLocation loc) {
        super(loc);
    }

    public LocationConfigMap(AbstractLocation loc, Map<ConfigKey<?>, Object> storage) {
        super(loc, storage);
    }

    @Override
    protected ExecutionContext getExecutionContext(BrooklynObject bo) {
        Entity contextEntity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
        if (contextEntity != null) {
            return ((EntityInternal)contextEntity).getExecutionContext();
        }
        log.trace("No resolving context found, will use global execution context. Could lead to NPE on DSL resolving.");
        if (bo == null) {
            return null;
        }
        ManagementContext mgmt = ((AbstractLocation)bo).getManagementContext();
        if (mgmt == null) {
            return null;
        }
        return mgmt.getServerExecutionContext();
    }

    @Override
    protected void postLocalEvaluate(ConfigKey<?> key, BrooklynObject bo, Maybe<?> rawValue, Maybe<?> resolvedValue) {
    }

    @Override
    protected void postSetConfig() {
    }

    public LocationConfigMap submap(Predicate<ConfigKey<?>> filter) {
        throw new UnsupportedOperationException("Location does not support submap");
    }

    @Override
    protected Object coerceConfigVal(ConfigKey<?> key, Object v) {
        if ((Class.class.isAssignableFrom(key.getType()) || Function.class.isAssignableFrom(key.getType())) && v instanceof String) {
            return v;
        }
        return super.coerceConfigVal(key, v);
    }

    @Override
    protected Location getParentOfContainer(Location container) {
        if (container == null) {
            return null;
        }
        return container.getParent();
    }

    @Override
    @Nullable
    protected <T> ConfigKey<?> getKeyAtContainerImpl(@Nonnull Location container, ConfigKey<T> queryKey) {
        return ((AbstractLocation)container).getLocationTypeInternal().getConfigKey(queryKey.getName());
    }

    @Override
    protected Collection<ConfigKey<?>> getKeysAtContainer(Location container) {
        return ((AbstractLocation)container).getLocationTypeInternal().getConfigKeys().values();
    }
}

