/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.network;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.network.AbstractOnNetworkEnricher;
import org.apache.brooklyn.util.text.Strings;

@Catalog(name="Subnet Network Advertiser", description="Advertises entity's subnet mapped ports. This can be used with sensors of type URI, HostAndPort or plain integer port values")
@Beta
public class OnSubnetNetworkEnricher
extends AbstractOnNetworkEnricher {
    public static ConfigKey<Function<? super String, String>> SENSOR_NAME_CONVERTER = ConfigKeys.newConfigKeyWithDefault(AbstractOnNetworkEnricher.SENSOR_NAME_CONVERTER, new AbstractOnNetworkEnricher.SensorNameConverter("subnet"));

    @Override
    protected Optional<HostAndPort> getMappedEndpoint(Entity source, MachineLocation machine, int port) {
        String address = (String)source.sensors().get(Attributes.SUBNET_ADDRESS);
        if (Strings.isNonBlank((CharSequence)address)) {
            return Optional.of((Object)HostAndPort.fromParts((String)address, (int)port));
        }
        return Optional.absent();
    }
}

