/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.spi.ApplicationComponent;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.PlatformComponent;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;
import org.apache.brooklyn.camp.spi.PlatformTransaction;
import org.apache.brooklyn.camp.spi.collection.BasicResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCampPlatform
extends CampPlatform {
    private static final Logger log = LoggerFactory.getLogger(BasicCampPlatform.class);
    BasicResourceLookup<PlatformComponentTemplate> platformComponentTemplates = new BasicResourceLookup();
    BasicResourceLookup<ApplicationComponentTemplate> applicationComponentTemplates = new BasicResourceLookup();
    BasicResourceLookup<AssemblyTemplate> assemblyTemplates = new BasicResourceLookup();
    BasicResourceLookup<PlatformComponent> platformComponents = new BasicResourceLookup();
    BasicResourceLookup<ApplicationComponent> applicationComponents = new BasicResourceLookup();
    BasicResourceLookup<Assembly> assemblies = new BasicResourceLookup();

    public BasicCampPlatform() {
        this((PlatformRootSummary)((PlatformRootSummary.Builder)PlatformRootSummary.builder().name("CAMP Platform")).build());
    }

    public BasicCampPlatform(PlatformRootSummary root) {
        super(root);
    }

    public BasicResourceLookup<PlatformComponentTemplate> platformComponentTemplates() {
        return this.platformComponentTemplates;
    }

    public BasicResourceLookup<ApplicationComponentTemplate> applicationComponentTemplates() {
        return this.applicationComponentTemplates;
    }

    public BasicResourceLookup<AssemblyTemplate> assemblyTemplates() {
        return this.assemblyTemplates;
    }

    public BasicResourceLookup<PlatformComponent> platformComponents() {
        return this.platformComponents;
    }

    public BasicResourceLookup<ApplicationComponent> applicationComponents() {
        return this.applicationComponents;
    }

    public BasicResourceLookup<Assembly> assemblies() {
        return this.assemblies;
    }

    @Override
    public PlatformTransaction transaction() {
        return new BasicPlatformTransaction(this);
    }

    public static class BasicPlatformTransaction
    extends PlatformTransaction {
        private final BasicCampPlatform platform;
        private final AtomicBoolean committed = new AtomicBoolean(false);

        public BasicPlatformTransaction(BasicCampPlatform platform) {
            this.platform = platform;
        }

        @Override
        public void commit() {
            if (this.committed.getAndSet(true)) {
                throw new IllegalStateException("transaction being committed multiple times");
            }
            for (Object o : this.additions) {
                if (o instanceof AssemblyTemplate) {
                    this.platform.assemblyTemplates.add((AssemblyTemplate)o);
                    continue;
                }
                if (o instanceof PlatformComponentTemplate) {
                    this.platform.platformComponentTemplates.add((PlatformComponentTemplate)o);
                    continue;
                }
                if (o instanceof ApplicationComponentTemplate) {
                    this.platform.applicationComponentTemplates.add((ApplicationComponentTemplate)o);
                    continue;
                }
                if (o instanceof Assembly) {
                    this.platform.assemblies.add((Assembly)o);
                    continue;
                }
                if (o instanceof PlatformComponent) {
                    this.platform.platformComponents.add((PlatformComponent)o);
                    continue;
                }
                if (o instanceof ApplicationComponent) {
                    this.platform.applicationComponents.add((ApplicationComponent)o);
                    continue;
                }
                throw new UnsupportedOperationException("Object " + o + " of type " + o.getClass() + " cannot be added to " + this.platform);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.committed.get()) {
                log.debug("transaction " + this + " was never applied");
            }
            super.finalize();
        }
    }
}

