/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.pipespec.integration.traits.quarkus.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"buildMode", "configuration", "enabled", "nativeBaseImage", "nativeBuilderImage", "packageTypes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Quarkus
implements KubernetesResource {
    @JsonProperty(value="buildMode")
    @JsonPropertyDescription(value="The Quarkus mode to run: either `jvm` or `native` (default `jvm`). In case both `jvm` and `native` are specified, two `IntegrationKit` resources are created, with the `native` kit having precedence over the `jvm` one once ready.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<BuildMode> buildMode;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="nativeBaseImage")
    @JsonPropertyDescription(value="The base image to use when running a native build (default `quay.io/quarkus/quarkus-micro-image:2.0`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String nativeBaseImage;
    @JsonProperty(value="nativeBuilderImage")
    @JsonPropertyDescription(value="The image containing the tooling required for a native build (by default it will use the one provided in the runtime catalog)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String nativeBuilderImage;
    @JsonProperty(value="packageTypes")
    @JsonPropertyDescription(value="The Quarkus package types, `fast-jar` or `native` (default `fast-jar`). In case both `fast-jar` and `native` are specified, two `IntegrationKit` resources are created, with the native kit having precedence over the `fast-jar` one once ready. The order influences the resolution of the current kit for the integration. The kit corresponding to the first package type will be assigned to the integration in case no existing kit that matches the integration exists. Deprecated: use `build-mode` instead.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<PackageTypes> packageTypes;

    public List<BuildMode> getBuildMode() {
        return this.buildMode;
    }

    public void setBuildMode(List<BuildMode> buildMode) {
        this.buildMode = buildMode;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getNativeBaseImage() {
        return this.nativeBaseImage;
    }

    public void setNativeBaseImage(String nativeBaseImage) {
        this.nativeBaseImage = nativeBaseImage;
    }

    public String getNativeBuilderImage() {
        return this.nativeBuilderImage;
    }

    public void setNativeBuilderImage(String nativeBuilderImage) {
        this.nativeBuilderImage = nativeBuilderImage;
    }

    public List<PackageTypes> getPackageTypes() {
        return this.packageTypes;
    }

    public void setPackageTypes(List<PackageTypes> packageTypes) {
        this.packageTypes = packageTypes;
    }

    public String toString() {
        return "Quarkus(buildMode=" + this.getBuildMode() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", nativeBaseImage=" + this.getNativeBaseImage() + ", nativeBuilderImage=" + this.getNativeBuilderImage() + ", packageTypes=" + this.getPackageTypes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quarkus)) {
            return false;
        }
        Quarkus other = (Quarkus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        List<BuildMode> this$buildMode = this.getBuildMode();
        List<BuildMode> other$buildMode = other.getBuildMode();
        if (this$buildMode == null ? other$buildMode != null : !((Object)this$buildMode).equals(other$buildMode)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$nativeBaseImage = this.getNativeBaseImage();
        String other$nativeBaseImage = other.getNativeBaseImage();
        if (this$nativeBaseImage == null ? other$nativeBaseImage != null : !this$nativeBaseImage.equals(other$nativeBaseImage)) {
            return false;
        }
        String this$nativeBuilderImage = this.getNativeBuilderImage();
        String other$nativeBuilderImage = other.getNativeBuilderImage();
        if (this$nativeBuilderImage == null ? other$nativeBuilderImage != null : !this$nativeBuilderImage.equals(other$nativeBuilderImage)) {
            return false;
        }
        List<PackageTypes> this$packageTypes = this.getPackageTypes();
        List<PackageTypes> other$packageTypes = other.getPackageTypes();
        return !(this$packageTypes == null ? other$packageTypes != null : !((Object)this$packageTypes).equals(other$packageTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Quarkus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        List<BuildMode> $buildMode = this.getBuildMode();
        result = result * 59 + ($buildMode == null ? 43 : ((Object)$buildMode).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $nativeBaseImage = this.getNativeBaseImage();
        result = result * 59 + ($nativeBaseImage == null ? 43 : $nativeBaseImage.hashCode());
        String $nativeBuilderImage = this.getNativeBuilderImage();
        result = result * 59 + ($nativeBuilderImage == null ? 43 : $nativeBuilderImage.hashCode());
        List<PackageTypes> $packageTypes = this.getPackageTypes();
        result = result * 59 + ($packageTypes == null ? 43 : ((Object)$packageTypes).hashCode());
        return result;
    }

    public static enum PackageTypes {
        FASTJAR("fast-jar"),
        _NATIVE("native");

        String value;

        private PackageTypes(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum BuildMode {
        JVM("jvm"),
        _NATIVE("native");

        String value;

        private BuildMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

