/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilespec.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"address", "ca", "insecure", "organization", "secret"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Registry
implements KubernetesResource {
    @JsonProperty(value="address")
    @JsonPropertyDescription(value="the URI to access")
    @JsonSetter(nulls=Nulls.SKIP)
    private String address;
    @JsonProperty(value="ca")
    @JsonPropertyDescription(value="the configmap which stores the Certificate Authority")
    @JsonSetter(nulls=Nulls.SKIP)
    private String ca;
    @JsonProperty(value="insecure")
    @JsonPropertyDescription(value="if the container registry is insecure (ie, http only)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean insecure;
    @JsonProperty(value="organization")
    @JsonPropertyDescription(value="the registry organization")
    @JsonSetter(nulls=Nulls.SKIP)
    private String organization;
    @JsonProperty(value="secret")
    @JsonPropertyDescription(value="the secret where credentials are stored")
    @JsonSetter(nulls=Nulls.SKIP)
    private String secret;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCa() {
        return this.ca;
    }

    public void setCa(String ca) {
        this.ca = ca;
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public void setInsecure(Boolean insecure) {
        this.insecure = insecure;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String toString() {
        return "Registry(address=" + this.getAddress() + ", ca=" + this.getCa() + ", insecure=" + this.getInsecure() + ", organization=" + this.getOrganization() + ", secret=" + this.getSecret() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registry)) {
            return false;
        }
        Registry other = (Registry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$insecure = this.getInsecure();
        Boolean other$insecure = other.getInsecure();
        if (this$insecure == null ? other$insecure != null : !((Object)this$insecure).equals(other$insecure)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$ca = this.getCa();
        String other$ca = other.getCa();
        if (this$ca == null ? other$ca != null : !this$ca.equals(other$ca)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Registry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $insecure = this.getInsecure();
        result = result * 59 + ($insecure == null ? 43 : ((Object)$insecure).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $ca = this.getCa();
        result = result * 59 + ($ca == null ? 43 : $ca.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }
}

