/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.topologyspreadconstraints;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationspec.template.spec.topologyspreadconstraints.LabelSelector;
import org.apache.camel.v1.integrationspec.template.spec.topologyspreadconstraints.labelselector.MatchExpressions;
import org.apache.camel.v1.integrationspec.template.spec.topologyspreadconstraints.labelselector.MatchExpressionsBuilder;
import org.apache.camel.v1.integrationspec.template.spec.topologyspreadconstraints.labelselector.MatchExpressionsFluent;

public class LabelSelectorFluent<A extends LabelSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<MatchExpressionsBuilder> matchExpressions;
    private Map<String, String> matchLabels;

    public LabelSelectorFluent() {
    }

    public LabelSelectorFluent(LabelSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LabelSelector instance) {
        LabelSelector labelSelector = instance = instance != null ? instance : new LabelSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchLabels(instance.getMatchLabels());
        }
    }

    public A addToMatchExpressions(int index, MatchExpressions item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").add(index, builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatchExpressions(int index, MatchExpressions item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").set(index, builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchExpressions(MatchExpressions ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (MatchExpressions item : items) {
            MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchExpressions(Collection<MatchExpressions> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (MatchExpressions item : items) {
            MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchExpressions(MatchExpressions ... items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (MatchExpressions item : items) {
            MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchExpressions(Collection<MatchExpressions> items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (MatchExpressions item : items) {
            MatchExpressionsBuilder builder = new MatchExpressionsBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchExpressions(Predicate<MatchExpressionsBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        Iterator<MatchExpressionsBuilder> each = this.matchExpressions.iterator();
        List visitables = this._visitables.get((Object)"matchExpressions");
        while (each.hasNext()) {
            MatchExpressionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MatchExpressions> buildMatchExpressions() {
        return this.matchExpressions != null ? LabelSelectorFluent.build(this.matchExpressions) : null;
    }

    public MatchExpressions buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public MatchExpressions buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public MatchExpressions buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public MatchExpressions buildMatchingMatchExpression(Predicate<MatchExpressionsBuilder> predicate) {
        for (MatchExpressionsBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<MatchExpressionsBuilder> predicate) {
        for (MatchExpressionsBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<MatchExpressions> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get((Object)"matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (MatchExpressions item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchExpressions(MatchExpressions ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove((Object)"matchExpressions");
        }
        if (matchExpressions != null) {
            for (MatchExpressions item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(MatchExpressions item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, MatchExpressions item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<MatchExpressionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)((Object)this);
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorFluent that = (LabelSelectorFluent)((Object)o);
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        return Objects.equals(this.matchLabels, that.matchLabels);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchLabels, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchExpressionsNested<N>
    extends MatchExpressionsFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        MatchExpressionsBuilder builder;
        int index;

        MatchExpressionsNested(int index, MatchExpressions item) {
            this.index = index;
            this.builder = new MatchExpressionsBuilder(this, item);
        }

        public N and() {
            return (N)LabelSelectorFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

