/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.pipespec.integration.traits.KnativeService;
import org.apache.camel.v1.pipespec.integration.traits.knativeservice.Configuration;
import org.apache.camel.v1.pipespec.integration.traits.knativeservice.ConfigurationBuilder;
import org.apache.camel.v1.pipespec.integration.traits.knativeservice.ConfigurationFluent;

public class KnativeServiceFluent<A extends KnativeServiceFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private Boolean auto;
    private String autoscalingMetric;
    private Long autoscalingTarget;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Long maxScale;
    private Long minScale;
    private String rolloutDuration;
    private KnativeService.Visibility visibility;

    public KnativeServiceFluent() {
    }

    public KnativeServiceFluent(KnativeService instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KnativeService instance) {
        KnativeService knativeService = instance = instance != null ? instance : new KnativeService();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withAuto(instance.getAuto());
            this.withAutoscalingMetric(instance.getAutoscalingMetric());
            this.withAutoscalingTarget(instance.getAutoscalingTarget());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withMaxScale(instance.getMaxScale());
            this.withMinScale(instance.getMinScale());
            this.withRolloutDuration(instance.getRolloutDuration());
            this.withVisibility(instance.getVisibility());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public String getAutoscalingMetric() {
        return this.autoscalingMetric;
    }

    public A withAutoscalingMetric(String autoscalingMetric) {
        this.autoscalingMetric = autoscalingMetric;
        return (A)((Object)this);
    }

    public boolean hasAutoscalingMetric() {
        return this.autoscalingMetric != null;
    }

    public Long getAutoscalingTarget() {
        return this.autoscalingTarget;
    }

    public A withAutoscalingTarget(Long autoscalingTarget) {
        this.autoscalingTarget = autoscalingTarget;
        return (A)((Object)this);
    }

    public boolean hasAutoscalingTarget() {
        return this.autoscalingTarget != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Long getMaxScale() {
        return this.maxScale;
    }

    public A withMaxScale(Long maxScale) {
        this.maxScale = maxScale;
        return (A)((Object)this);
    }

    public boolean hasMaxScale() {
        return this.maxScale != null;
    }

    public Long getMinScale() {
        return this.minScale;
    }

    public A withMinScale(Long minScale) {
        this.minScale = minScale;
        return (A)((Object)this);
    }

    public boolean hasMinScale() {
        return this.minScale != null;
    }

    public String getRolloutDuration() {
        return this.rolloutDuration;
    }

    public A withRolloutDuration(String rolloutDuration) {
        this.rolloutDuration = rolloutDuration;
        return (A)((Object)this);
    }

    public boolean hasRolloutDuration() {
        return this.rolloutDuration != null;
    }

    public KnativeService.Visibility getVisibility() {
        return this.visibility;
    }

    public A withVisibility(KnativeService.Visibility visibility) {
        this.visibility = visibility;
        return (A)((Object)this);
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnativeServiceFluent that = (KnativeServiceFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals(this.autoscalingMetric, that.autoscalingMetric)) {
            return false;
        }
        if (!Objects.equals(this.autoscalingTarget, that.autoscalingTarget)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.maxScale, that.maxScale)) {
            return false;
        }
        if (!Objects.equals(this.minScale, that.minScale)) {
            return false;
        }
        if (!Objects.equals(this.rolloutDuration, that.rolloutDuration)) {
            return false;
        }
        return Objects.equals((Object)this.visibility, (Object)that.visibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.auto, this.autoscalingMetric, this.autoscalingTarget, this.configuration, this.enabled, this.maxScale, this.minScale, this.rolloutDuration, this.visibility, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.autoscalingMetric != null) {
            sb.append("autoscalingMetric:");
            sb.append(this.autoscalingMetric + ",");
        }
        if (this.autoscalingTarget != null) {
            sb.append("autoscalingTarget:");
            sb.append(this.autoscalingTarget + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.maxScale != null) {
            sb.append("maxScale:");
            sb.append(this.maxScale + ",");
        }
        if (this.minScale != null) {
            sb.append("minScale:");
            sb.append(this.minScale + ",");
        }
        if (this.rolloutDuration != null) {
            sb.append("rolloutDuration:");
            sb.append(this.rolloutDuration + ",");
        }
        if (this.visibility != null) {
            sb.append("visibility:");
            sb.append((Object)this.visibility);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)KnativeServiceFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

