/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.GitRepoBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"directory", "repository", "revision"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class GitRepo
implements Editable<GitRepoBuilder>,
KubernetesResource {
    @JsonProperty(value="directory")
    @JsonPropertyDescription(value="directory is the target directory name.\nMust not contain or start with '..'.  If '.' is supplied, the volume directory will be the\ngit repository.  Otherwise, if specified, the volume will contain the git repository in\nthe subdirectory with the given name.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String directory;
    @JsonProperty(value="repository")
    @Required
    @JsonPropertyDescription(value="repository is the URL")
    @JsonSetter(nulls=Nulls.SKIP)
    private String repository;
    @JsonProperty(value="revision")
    @JsonPropertyDescription(value="revision is the commit hash for the specified revision.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String revision;

    public GitRepoBuilder edit() {
        return new GitRepoBuilder(this);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String toString() {
        return "GitRepo(directory=" + this.getDirectory() + ", repository=" + this.getRepository() + ", revision=" + this.getRevision() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRepo)) {
            return false;
        }
        GitRepo other = (GitRepo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$directory = this.getDirectory();
        String other$directory = other.getDirectory();
        if (this$directory == null ? other$directory != null : !this$directory.equals(other$directory)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$revision = this.getRevision();
        String other$revision = other.getRevision();
        return !(this$revision == null ? other$revision != null : !this$revision.equals(other$revision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitRepo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $directory = this.getDirectory();
        result = result * 59 + ($directory == null ? 43 : $directory.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
        return result;
    }
}

