/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.lucene.util.automaton.Operations;

public final class Automata {
    public static final int MAX_STRING_UNION_TERM_LENGTH = 1000;

    private Automata() {
    }

    public static Automaton makeEmpty() {
        Automaton a = new Automaton();
        a.finishState();
        return a;
    }

    public static Automaton makeEmptyString() {
        Automaton a = new Automaton();
        a.createState();
        a.setAccept(0, true);
        return a;
    }

    public static Automaton makeAnyString() {
        Automaton a = new Automaton();
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 0x10FFFF);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyBinary() {
        Automaton a = new Automaton();
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 255);
        a.finishState();
        return a;
    }

    public static Automaton makeNonEmptyBinary() {
        Automaton a = new Automaton();
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, 0, 255);
        a.addTransition(s2, s2, 0, 255);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyChar() {
        return Automata.makeCharRange(0, 0x10FFFF);
    }

    public static int appendAnyChar(Automaton a, int state) {
        int newState = a.createState();
        a.addTransition(state, newState, 0, 0x10FFFF);
        return newState;
    }

    public static Automaton makeChar(int c) {
        return Automata.makeCharRange(c, c);
    }

    public static int appendChar(Automaton a, int state, int c) {
        int newState = a.createState();
        a.addTransition(state, newState, c, c);
        return newState;
    }

    public static Automaton makeCharRange(int min, int max) {
        if (min > max) {
            return Automata.makeEmpty();
        }
        Automaton a = new Automaton();
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, min, max);
        a.finishState();
        return a;
    }

    private static int anyOfRightLength(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), 48, 57);
        }
        return s;
    }

    private static int atLeast(Automaton.Builder builder, String x, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            if (zeros) {
                initials.add(s);
            }
            char c = x.charAt(n);
            builder.addTransition(s, Automata.atLeast(builder, x, n + 1, initials, zeros && c == '0'), c);
            if (c < '9') {
                builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), (char)(c + '\u0001'), 57);
            }
        }
        return s;
    }

    private static int atMost(Automaton.Builder builder, String x, int n) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char c = x.charAt(n);
            builder.addTransition(s, Automata.atMost(builder, x, (char)n + '\u0001'), c);
            if (c > '0') {
                builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), 48, (char)(c - '\u0001'));
            }
        }
        return s;
    }

    private static int between(Automaton.Builder builder, String x, String y, int n, Collection<Integer> initials, boolean zeros) {
        int s = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s, true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                builder.addTransition(s, Automata.between(builder, x, y, n + 1, initials, zeros && cx == '0'), cx);
            } else {
                builder.addTransition(s, Automata.atLeast(builder, x, n + 1, initials, zeros && cx == '0'), cx);
                builder.addTransition(s, Automata.atMost(builder, y, n + 1), cy);
                if (cx + '\u0001' < cy) {
                    builder.addTransition(s, Automata.anyOfRightLength(builder, x, n + 1), (char)(cx + '\u0001'), (char)(cy - '\u0001'));
                }
            }
        }
        return s;
    }

    private static boolean suffixIsZeros(BytesRef br, int len) {
        for (int i = len; i < br.length; ++i) {
            if (br.bytes[br.offset + i] == 0) continue;
            return false;
        }
        return true;
    }

    public static Automaton makeBinaryInterval(BytesRef min, boolean minInclusive, BytesRef max, boolean maxInclusive) {
        int i;
        int cmp;
        if (min == null && !minInclusive) {
            throw new IllegalArgumentException("minInclusive must be true when min is null (open ended)");
        }
        if (max == null && !maxInclusive) {
            throw new IllegalArgumentException("maxInclusive must be true when max is null (open ended)");
        }
        if (min == null) {
            min = new BytesRef();
            minInclusive = true;
        }
        if (max != null) {
            cmp = min.compareTo(max);
        } else {
            cmp = -1;
            if (min.length == 0) {
                if (minInclusive) {
                    return Automata.makeAnyBinary();
                }
                return Automata.makeNonEmptyBinary();
            }
        }
        if (cmp == 0) {
            if (!minInclusive || !maxInclusive) {
                return Automata.makeEmpty();
            }
            return Automata.makeBinary(min);
        }
        if (cmp > 0) {
            return Automata.makeEmpty();
        }
        if (max != null && StringHelper.startsWith(max, min) && Automata.suffixIsZeros(max, min.length)) {
            int state;
            int i2;
            int maxLength = max.length;
            assert (maxLength > min.length);
            if (!maxInclusive) {
                --maxLength;
            }
            if (maxLength == min.length) {
                if (!minInclusive) {
                    return Automata.makeEmpty();
                }
                return Automata.makeBinary(min);
            }
            Automaton a = new Automaton();
            int lastState = a.createState();
            for (i2 = 0; i2 < min.length; ++i2) {
                state = a.createState();
                int label = min.bytes[min.offset + i2] & 0xFF;
                a.addTransition(lastState, state, label);
                lastState = state;
            }
            if (minInclusive) {
                a.setAccept(lastState, true);
            }
            for (i2 = min.length; i2 < maxLength; ++i2) {
                state = a.createState();
                a.addTransition(lastState, state, 0);
                a.setAccept(state, true);
                lastState = state;
            }
            a.finishState();
            return a;
        }
        Automaton a = new Automaton();
        int startState = a.createState();
        int sinkState = a.createState();
        a.setAccept(sinkState, true);
        a.addTransition(sinkState, sinkState, 0, 255);
        boolean equalPrefix = true;
        int lastState = startState;
        int firstMaxState = -1;
        int sharedPrefixLength = 0;
        for (i = 0; i < min.length; ++i) {
            int minLabel = min.bytes[min.offset + i] & 0xFF;
            int maxLabel = max != null && equalPrefix && i < max.length ? max.bytes[max.offset + i] & 0xFF : -1;
            int nextState = minInclusive && i == min.length - 1 && (!equalPrefix || minLabel != maxLabel) ? sinkState : a.createState();
            if (equalPrefix) {
                if (minLabel == maxLabel) {
                    a.addTransition(lastState, nextState, minLabel);
                } else if (max == null) {
                    equalPrefix = false;
                    sharedPrefixLength = 0;
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                    a.addTransition(lastState, nextState, minLabel);
                } else {
                    assert (maxLabel > minLabel);
                    a.addTransition(lastState, nextState, minLabel);
                    if (maxLabel > minLabel + 1) {
                        a.addTransition(lastState, sinkState, minLabel + 1, maxLabel - 1);
                    }
                    if (maxInclusive || i < max.length - 1) {
                        firstMaxState = a.createState();
                        if (i < max.length - 1) {
                            a.setAccept(firstMaxState, true);
                        }
                        a.addTransition(lastState, firstMaxState, maxLabel);
                    }
                    equalPrefix = false;
                    sharedPrefixLength = i;
                }
            } else {
                a.addTransition(lastState, nextState, minLabel);
                if (minLabel < 255) {
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                }
            }
            lastState = nextState;
        }
        if (!equalPrefix && lastState != sinkState && lastState != startState) {
            a.addTransition(lastState, sinkState, 0, 255);
        }
        if (minInclusive) {
            a.setAccept(lastState, true);
        }
        if (max != null) {
            if (firstMaxState == -1) {
                sharedPrefixLength = min.length;
            } else {
                lastState = firstMaxState;
                ++sharedPrefixLength;
            }
            for (i = sharedPrefixLength; i < max.length; ++i) {
                int maxLabel = max.bytes[max.offset + i] & 0xFF;
                if (maxLabel > 0) {
                    a.addTransition(lastState, sinkState, 0, maxLabel - 1);
                }
                if (!maxInclusive && i >= max.length - 1) continue;
                int nextState = a.createState();
                if (i < max.length - 1) {
                    a.setAccept(nextState, true);
                }
                a.addTransition(lastState, nextState, maxLabel);
                lastState = nextState;
            }
            if (maxInclusive) {
                a.setAccept(lastState, true);
            }
        }
        a.finishState();
        assert (a.isDeterministic()) : a.toDot();
        return a;
    }

    public static Automaton makeDecimalInterval(int min, int max, int digits) throws IllegalArgumentException {
        String x = Integer.toString(min);
        String y = Integer.toString(max);
        if (min > max || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i = x.length(); i < d; ++i) {
            bx.append('0');
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by = new StringBuilder();
        for (int i = y.length(); i < d; ++i) {
            by.append('0');
        }
        by.append(y);
        y = by.toString();
        Automaton.Builder builder = new Automaton.Builder();
        if (digits <= 0) {
            builder.createState();
        }
        ArrayList<Integer> initials = new ArrayList<Integer>();
        Automata.between(builder, x, y, 0, initials, digits <= 0);
        Automaton a1 = builder.finish();
        if (digits <= 0) {
            a1.addTransition(0, 0, 48);
            Iterator iterator = initials.iterator();
            while (iterator.hasNext()) {
                int p = (Integer)iterator.next();
                a1.addEpsilon(0, p);
            }
            a1.finishState();
        }
        return a1;
    }

    public static Automaton makeString(String s) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            int state = a.createState();
            cp = s.codePointAt(i);
            a.addTransition(lastState, state, cp);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeBinary(BytesRef term) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        for (int i = 0; i < term.length; ++i) {
            int state = a.createState();
            int label = term.bytes[term.offset + i] & 0xFF;
            a.addTransition(lastState, state, label);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeString(int[] word, int offset, int length) {
        Automaton a = new Automaton();
        a.createState();
        int s = 0;
        for (int i = offset; i < offset + length; ++i) {
            int s2 = a.createState();
            a.addTransition(s, s2, word[i]);
            s = s2;
        }
        a.setAccept(s, true);
        a.finishState();
        return a;
    }

    public static Automaton makeStringUnion(Collection<BytesRef> utf8Strings) {
        if (utf8Strings.isEmpty()) {
            return Automata.makeEmpty();
        }
        return DaciukMihovAutomatonBuilder.build(utf8Strings, false);
    }

    public static Automaton makeBinaryStringUnion(Collection<BytesRef> utf8Strings) {
        if (utf8Strings.isEmpty()) {
            return Automata.makeEmpty();
        }
        return DaciukMihovAutomatonBuilder.build(utf8Strings, true);
    }

    public static Automaton makeStringUnion(BytesRefIterator utf8Strings) throws IOException {
        return DaciukMihovAutomatonBuilder.build(utf8Strings, false);
    }

    public static Automaton makeBinaryStringUnion(BytesRefIterator utf8Strings) throws IOException {
        return DaciukMihovAutomatonBuilder.build(utf8Strings, true);
    }
}

