/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.schema.AbstractSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseAccessor<T extends TableSchema> {
    public final CQLSessionProvider cqlSessionProvider;
    protected final T tableSchema;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected DatabaseAccessor(T tableSchema, CQLSessionProvider sessionProvider) {
        this.tableSchema = tableSchema;
        this.cqlSessionProvider = sessionProvider;
    }

    @NotNull
    public Session session() {
        return this.cqlSessionProvider.get();
    }

    public boolean isAvailable() {
        return ((AbstractSchema)this.tableSchema).isInitialized();
    }

    protected ResultSet execute(Statement statement) {
        return this.session().execute(statement);
    }
}

