/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AbortRestoreJobRequestPayload {
    private static final Pattern ALPHANUMERIC_BLANK_ONLY = Pattern.compile("^[a-zA-Z0-9 ]*$");
    private final String reason;

    @JsonCreator
    public AbortRestoreJobRequestPayload(@JsonProperty(value="reason") @Nullable String reason) {
        this.reason = this.validateContent(reason);
    }

    @JsonProperty(value="reason")
    public String reason() {
        return this.reason;
    }

    private String validateContent(String reason) {
        if (reason == null) {
            return null;
        }
        Preconditions.checkArgument(reason.length() <= 1024, "Reason string is too long");
        Preconditions.checkArgument(ALPHANUMERIC_BLANK_ONLY.matcher(reason).matches(), "Reason string cannot contain non-alphanumeric-blank characters");
        return reason;
    }
}

