/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EhCacheQueryCache
implements QueryCache {
    static final String DEFAULT_CACHE_NAME = "cayenne.default.cachegroup";
    private static Log logger = LogFactory.getLog(EhCacheQueryCache.class);
    protected CacheManager cacheManager;

    public EhCacheQueryCache() {
        this.cacheManager = new CacheManager();
        this.init();
    }

    public EhCacheQueryCache(String configFile) {
        this.cacheManager = new CacheManager(configFile);
        this.init();
    }

    public EhCacheQueryCache(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new CayenneRuntimeException("CacheManager cannot be null.", new Object[0]);
        }
        this.cacheManager = cacheManager;
        this.init();
    }

    private void init() {
        this.cacheManager.addCacheIfAbsent(DEFAULT_CACHE_NAME);
    }

    public List get(QueryMetadata metadata) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        String cacheName = this.cacheName(key, metadata.getCacheGroups());
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Element result = cache.get((Serializable)((Object)key));
        return result != null ? (List)result.getObjectValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        String cacheName = this.cacheName(key, metadata.getCacheGroups());
        Ehcache cache = this.cacheManager.addCacheIfAbsent(cacheName);
        Element result = cache.get((Serializable)((Object)key));
        if (result != null) {
            return (List)result.getObjectValue();
        }
        cache.acquireWriteLockOnKey((Object)key);
        try {
            result = cache.get((Serializable)((Object)key));
            if (result != null) {
                List list = (List)result.getObjectValue();
                return list;
            }
            Object object = factory.createObject();
            if (!(object instanceof List)) {
                if (object == null) {
                    throw new CayenneRuntimeException("Null object created: " + metadata.getCacheKey(), new Object[0]);
                }
                throw new CayenneRuntimeException("Invalid query result, expected List, got " + object.getClass().getName(), new Object[0]);
            }
            cache.put(new Element((Object)key, object));
            List list = (List)object;
            return list;
        }
        finally {
            cache.releaseWriteLockOnKey((Object)key);
        }
    }

    private String cacheName(String key, String ... cacheGroups) {
        if (cacheGroups != null && cacheGroups.length > 0) {
            if (cacheGroups.length > 1) {
                logger.warn((Object)("multiple cache groups per key '" + key + "', ignoring all but the first one: " + cacheGroups[0]));
            }
            return cacheGroups[0];
        }
        return DEFAULT_CACHE_NAME;
    }

    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            String cacheName = this.cacheName(key, metadata.getCacheGroups());
            Ehcache cache = this.cacheManager.addCacheIfAbsent(cacheName);
            cache.put(new Element((Object)key, (Object)results));
        }
    }

    public void remove(String key) {
        if (key != null) {
            for (String cache : this.cacheManager.getCacheNames()) {
                this.cacheManager.getCache(cache).remove((Serializable)((Object)key));
            }
        }
    }

    public void removeGroup(String groupKey) {
        Ehcache cache = this.cacheManager.getEhcache(groupKey);
        if (cache != null) {
            cache.removeAll();
        }
    }

    public void clear() {
        this.cacheManager.removalAll();
    }

    public int size() {
        int size = 0;
        for (String cache : this.cacheManager.getCacheNames()) {
            size += this.cacheManager.getCache(cache).getSize();
        }
        return size;
    }

    public Ehcache getDefaultCache() {
        return this.cacheManager.getCache(DEFAULT_CACHE_NAME);
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.cacheManager.shutdown();
    }
}

