/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.dialog.FindDialogView;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;

public class FindDialog
extends CayenneController {
    private FindDialogView view;
    private List paths;
    private static Font font;
    private static Font fontSelected;

    public static Font getFont() {
        return font;
    }

    public static Font getFontSelected() {
        return fontSelected;
    }

    public FindDialog(CayenneController parent, List paths) {
        super(parent);
        this.paths = paths;
        HashMap<Integer, String> objEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> dbEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> attrNames = new HashMap<Integer, String>();
        HashMap<Integer, String> relatNames = new HashMap<Integer, String>();
        HashMap<Integer, String> queryNames = new HashMap<Integer, String>();
        HashMap<Integer, String> embeddableNames = new HashMap<Integer, String>();
        HashMap<Integer, String> embeddableAttributeNames = new HashMap<Integer, String>();
        Iterator it = paths.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object parentObject;
            Object path = it.next();
            if (path instanceof ObjEntity) {
                objEntityNames.put(new Integer(index++), ((ObjEntity)path).getName());
                continue;
            }
            if (path instanceof DbEntity) {
                dbEntityNames.put(new Integer(index++), ((DbEntity)path).getName());
                continue;
            }
            if (path instanceof Query) {
                queryNames.put(new Integer(index++), ((Query)path).getName());
                continue;
            }
            if (path instanceof Embeddable) {
                String name = ((Embeddable)path).getClassName();
                embeddableNames.put(new Integer(index++), name);
                continue;
            }
            if (path instanceof EmbeddableAttribute) {
                parentObject = ((EmbeddableAttribute)path).getEmbeddable();
                embeddableAttributeNames.put(new Integer(index++), ((Embeddable)parentObject).getClassName() + "." + ((EmbeddableAttribute)path).getName());
                continue;
            }
            if (path instanceof Attribute) {
                parentObject = ((Attribute)path).getParent();
                attrNames.put(new Integer(index++), this.getParentName(parentObject) + "." + ((Attribute)path).getName());
                continue;
            }
            if (!(path instanceof Relationship)) continue;
            parentObject = ((Relationship)path).getParent();
            String parentName = this.getParentName(parentObject);
            relatNames.put(new Integer(index++), parentName + "." + ((Relationship)path).getName());
        }
        this.view = new FindDialogView(objEntityNames, dbEntityNames, attrNames, relatNames, queryNames, embeddableNames, embeddableAttributeNames);
        this.initBindings();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.setVisible(true);
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.view.dispose();
            }
        });
        font = this.view.getOkButton().getFont();
        fontSelected = new Font(font.getFamily(), 1, font.getSize() + 2);
        JTable table = this.view.getTable();
        table.setRowHeight(fontSelected.getSize() + 6);
        table.setRowMargin(0);
        table.addKeyListener(new JumpToResultsKeyListener());
        table.addMouseListener(new JumpToResultActionListener());
        table.getSelectionModel().setSelectionInterval(0, 0);
    }

    public static void jumpToResult(Object path) {
        EditorView editor = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        DataChannelDescriptor domain = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        if (path instanceof Entity) {
            Object[] o = new Object[]{domain, ((Entity)path).getDataMap(), (Entity)path};
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            EntityDisplayEvent event = new EntityDisplayEvent((Object)editor.getProjectTreeView(), (Entity)path, ((Entity)path).getDataMap(), domain);
            event.setMainTabFocus(true);
            if (path instanceof ObjEntity) {
                editor.getObjDetailView().currentObjEntityChanged(event);
            }
            if (path instanceof DbEntity) {
                editor.getDbDetailView().currentDbEntityChanged(event);
            }
        } else if (path instanceof Query) {
            DataMap dmForQuery = null;
            if (path instanceof EJBQLQuery) {
                dmForQuery = ((EJBQLQuery)path).getDataMap();
            }
            if (path instanceof AbstractQuery) {
                dmForQuery = ((AbstractQuery)path).getDataMap();
            }
            Object[] o = new Object[]{domain, dmForQuery, (Query)path};
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            QueryDisplayEvent event = new QueryDisplayEvent((Object)editor.getProjectTreeView(), (Query)path, dmForQuery, domain);
            editor.currentQueryChanged(event);
        } else if (path instanceof Embeddable) {
            Object[] o = new Object[]{domain, ((Embeddable)path).getDataMap(), (Embeddable)path};
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            EmbeddableDisplayEvent event = new EmbeddableDisplayEvent((Object)editor.getProjectTreeView(), (Embeddable)path, ((Embeddable)path).getDataMap(), domain);
            event.setMainTabFocus(true);
            editor.currentEmbeddableChanged(event);
        } else if (path instanceof EmbeddableAttribute) {
            Object[] o = new Object[]{domain, ((EmbeddableAttribute)path).getEmbeddable().getDataMap(), ((EmbeddableAttribute)path).getEmbeddable()};
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            EmbeddableAttributeDisplayEvent event = new EmbeddableAttributeDisplayEvent((Object)editor.getProjectTreeView(), ((EmbeddableAttribute)path).getEmbeddable(), (EmbeddableAttribute)path, ((EmbeddableAttribute)path).getEmbeddable().getDataMap(), domain);
            event.setMainTabFocus(true);
            editor.getEmbeddableView().currentEmbeddableAttributeChanged(event);
        } else if (path instanceof Attribute || path instanceof Relationship) {
            EntityDisplayEvent event;
            Object[] o = new Object[3];
            o[0] = domain;
            if (path instanceof Attribute) {
                o[1] = ((Attribute)path).getEntity().getDataMap();
                o[2] = ((Attribute)path).getEntity();
            } else {
                o[1] = ((Relationship)path).getSourceEntity().getDataMap();
                o[2] = ((Relationship)path).getSourceEntity();
            }
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            if (path instanceof DbAttribute) {
                event = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path, ((Attribute)path).getEntity(), ((Attribute)path).getEntity().getDataMap(), domain);
                event.setMainTabFocus(true);
                editor.getDbDetailView().currentDbAttributeChanged((AttributeDisplayEvent)event);
            }
            if (path instanceof ObjAttribute) {
                event = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path, ((Attribute)path).getEntity(), ((Attribute)path).getEntity().getDataMap(), domain);
                event.setMainTabFocus(true);
                editor.getObjDetailView().currentObjAttributeChanged((AttributeDisplayEvent)event);
            }
            if (path instanceof DbRelationship) {
                event = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path, ((Relationship)path).getSourceEntity(), ((Relationship)path).getSourceEntity().getDataMap(), domain);
                event.setMainTabFocus(true);
                editor.getDbDetailView().currentDbRelationshipChanged((RelationshipDisplayEvent)event);
            }
            if (path instanceof ObjRelationship) {
                event = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path, ((Relationship)path).getSourceEntity(), ((Relationship)path).getSourceEntity().getDataMap(), domain);
                event.setMainTabFocus(true);
                editor.getObjDetailView().currentObjRelationshipChanged((RelationshipDisplayEvent)event);
            }
        }
    }

    private static TreePath buildTreePath(Object[] path, EditorView editor) {
        Object[] mutableTreeNodes = new Object[path.length];
        mutableTreeNodes[0] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getRootNode();
        for (int i = 1; i < path.length; ++i) {
            Object[] helper = new Object[i];
            int j = 0;
            while (j < i) {
                helper[j++] = path[j];
            }
            mutableTreeNodes[i] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getNodeForObjectPath(helper);
        }
        return new TreePath(mutableTreeNodes);
    }

    private String getParentName(Object parentObject) {
        String nameParent = null;
        if (parentObject instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)parentObject;
            nameParent = objEntity.getName();
        }
        if (parentObject instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)parentObject;
            nameParent = dbEntity.getName();
        }
        if (parentObject instanceof Embeddable) {
            Embeddable embeddable = (Embeddable)parentObject;
            nameParent = embeddable.getClassName();
        }
        return nameParent;
    }

    private class JumpToResultsKeyListener
    implements KeyListener {
        private JumpToResultsKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                JTable table = (JTable)e.getSource();
                Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
                JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
                Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
                Object[] path = (Object[])FindDialog.this.paths.get(index);
                FindDialog.jumpToResult(path);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class JumpToResultActionListener
    implements MouseListener {
        private JumpToResultActionListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
            JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
            Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
            Object path = FindDialog.this.paths.get(index);
            FindDialog.jumpToResult(path);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

