/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.util.CayenneUserDir;
import org.apache.cayenne.pref.Preference;
import org.apache.cayenne.pref.PreferenceDecorator;
import org.apache.commons.collections.ExtendedProperties;

public class UpgradeCayennePreference
extends PreferenceDecorator {
    public static final String PREFERENCES_NAME_OLD = "modeler.preferences";
    public static final String LAST_PROJ_FILES_OLD = "Editor.lastSeveralProjectFiles";
    public static final String EDITOR_LAFNAME_OLD = "Editor.lookAndFeel";
    public static final String EDITOR_THEMENAME_OLD = "Editor.theme";
    public static final String EDITOR_LOGFILE_ENABLED_OLD = "Editor.logfileEnabled";
    public static final String EDITOR_LOGFILE_OLD = "Editor.logfile";

    public UpgradeCayennePreference(Preference delegate) {
        super(delegate);
    }

    public void upgrade() {
        block7: {
            try {
                File prefsFile;
                if (Preferences.userRoot().nodeExists("org/apache/cayenne") || !(prefsFile = new File(this.preferencesDirectory(), PREFERENCES_NAME_OLD)).exists()) break block7;
                ExtendedProperties ep = new ExtendedProperties();
                try {
                    ep.load(new FileInputStream(prefsFile));
                    Preferences prefEditor = Preferences.userRoot().node("org/apache/cayenne").node("editor");
                    prefEditor.putBoolean("logfileEnabled", ep.getBoolean(EDITOR_LOGFILE_ENABLED_OLD));
                    prefEditor.put("logfile", ep.getString(EDITOR_LOGFILE_OLD));
                    Preferences frefLastProjFiles = prefEditor.node("lastSeveralProjectFiles");
                    Vector arr = ep.getVector(LAST_PROJ_FILES_OLD);
                    while (arr.size() > 12) {
                        arr.remove(arr.size() - 1);
                    }
                    frefLastProjFiles.clear();
                    int size = arr.size();
                    for (int i = 0; i < size; ++i) {
                        frefLastProjFiles.put(String.valueOf(i), arr.get(i).toString());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public File preferencesDirectory() {
        return CayenneUserDir.getInstance().getDirectory();
    }

    public Preferences getRootPreference() {
        this.upgrade();
        return this.delegate.getRootPreference();
    }

    public Preferences getCayennePreference() {
        this.upgrade();
        return this.delegate.getCayennePreference();
    }

    public Preferences getCurrentPreference() {
        this.upgrade();
        return this.delegate.getCayennePreference();
    }
}

