/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.swing.BindingBase;
import org.apache.cayenne.validation.ValidationException;

public class TextBinding
extends BindingBase {
    protected JTextComponent textComponent;
    protected Color defaultBGColor;
    protected Color errorColor;
    protected String defaultToolTip;

    public TextBinding(JTextField textField, String expression) {
        super(expression);
        this.textComponent = textField;
        this.initComponentDefaults();
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!TextBinding.this.modelUpdateDisabled) {
                    TextBinding.this.updateModel();
                }
            }
        });
        this.textComponent.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent c) {
                TextBinding.this.updateModel();
                return true;
            }
        });
    }

    public TextBinding(JTextArea textArea, String property) {
        super(property);
        this.textComponent = textArea;
        this.initComponentDefaults();
        this.textComponent.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.verifyTextChange(e);
            }

            public void changedUpdate(DocumentEvent e) {
                this.verifyTextChange(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.verifyTextChange(e);
            }

            void verifyTextChange(DocumentEvent e) {
                if (!TextBinding.this.modelUpdateDisabled) {
                    TextBinding.this.updateModel();
                }
            }
        });
    }

    protected void initComponentDefaults() {
        this.errorColor = ValidatorDialog.WARNING_COLOR;
        this.defaultBGColor = this.textComponent.getBackground();
        this.defaultToolTip = this.textComponent.getToolTipText();
    }

    public void updateView() {
        Object value = this.getValue();
        String text = value != null ? value.toString() : null;
        this.modelUpdateDisabled = true;
        try {
            this.clear();
            this.textComponent.setText(text);
        }
        finally {
            this.modelUpdateDisabled = false;
        }
    }

    public Component getView() {
        return this.textComponent;
    }

    protected void updateModel() {
        try {
            this.setValue(this.textComponent.getText());
            this.clear();
        }
        catch (ValidationException vex) {
            this.textComponent.setBackground(this.errorColor);
            this.textComponent.setToolTipText(vex.getUnlabeledMessage());
        }
    }

    protected void clear() {
        this.textComponent.setBackground(this.defaultBGColor);
        this.textComponent.setToolTipText(this.defaultToolTip);
    }
}

