package org.apache.cayenne.testdo.testmap.auto;

import java.util.List;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;

/**
 * Class _ArtGroup was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _ArtGroup extends CayenneDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String GROUP_ID_PK_COLUMN = "GROUP_ID";

    public static final Property<String> NAME = Property.create("name", String.class);
    public static final Property<List<Artist>> ARTIST_ARRAY = Property.create("artistArray", List.class);
    public static final Property<List<ArtGroup>> CHILD_GROUPS_ARRAY = Property.create("childGroupsArray", List.class);
    public static final Property<ArtGroup> TO_PARENT_GROUP = Property.create("toParentGroup", ArtGroup.class);

    public void setName(String name) {
        writeProperty("name", name);
    }
    public String getName() {
        return (String)readProperty("name");
    }

    public void addToArtistArray(Artist obj) {
        addToManyTarget("artistArray", obj, true);
    }
    public void removeFromArtistArray(Artist obj) {
        removeToManyTarget("artistArray", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Artist> getArtistArray() {
        return (List<Artist>)readProperty("artistArray");
    }


    public void addToChildGroupsArray(ArtGroup obj) {
        addToManyTarget("childGroupsArray", obj, true);
    }
    public void removeFromChildGroupsArray(ArtGroup obj) {
        removeToManyTarget("childGroupsArray", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<ArtGroup> getChildGroupsArray() {
        return (List<ArtGroup>)readProperty("childGroupsArray");
    }


    public void setToParentGroup(ArtGroup toParentGroup) {
        setToOneTarget("toParentGroup", toParentGroup, true);
    }

    public ArtGroup getToParentGroup() {
        return (ArtGroup)readProperty("toParentGroup");
    }


}
