/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.undo.BaseRemovePropertyUndoableEdit;

public class RemoveRelationshipUndoableEdit
extends BaseRemovePropertyUndoableEdit {
    private ObjRelationship[] rels;
    private DbRelationship[] dbRels;

    public RemoveRelationshipUndoableEdit(ObjEntity objEntity, ObjRelationship[] rels) {
        this.objEntity = objEntity;
        this.rels = rels;
    }

    public RemoveRelationshipUndoableEdit(DbEntity dbEntity, DbRelationship[] dbRels) {
        this.dbEntity = dbEntity;
        this.dbRels = dbRels;
    }

    @Override
    public String getPresentationName() {
        if (this.objEntity != null) {
            return "Remove Obj Relationship";
        }
        return "Remove Db Relationship";
    }

    @Override
    public void redo() throws CannotRedoException {
        RemoveRelationshipAction action = this.actionManager.getAction(RemoveRelationshipAction.class);
        if (this.objEntity != null) {
            action.removeObjRelationships(this.objEntity, this.rels);
            this.focusObjEntity();
        } else {
            action.removeDbRelationships(this.dbEntity, this.dbRels);
            this.focusDBEntity();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        CreateRelationshipAction action = this.actionManager.getAction(CreateRelationshipAction.class);
        if (this.objEntity != null) {
            for (ObjRelationship r : this.rels) {
                action.createObjRelationship(this.objEntity, r);
            }
            this.focusObjEntity();
        } else {
            for (DbRelationship dr : this.dbRels) {
                action.createDbRelationship(this.dbEntity, dr);
            }
            this.focusDBEntity();
        }
    }
}

