/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.BindingBuilder;
import org.apache.cayenne.di.DecoratorBuilder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.spi.DefaultBindingBuilder;
import org.apache.cayenne.di.spi.DefaultDecoratorBuilder;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.DefaultListBuilder;
import org.apache.cayenne.di.spi.DefaultMapBuilder;

class DefaultBinder
implements Binder {
    private DefaultInjector injector;

    DefaultBinder(DefaultInjector injector) {
        this.injector = injector;
    }

    @Override
    public <T> BindingBuilder<T> bind(Class<T> interfaceType) {
        return new DefaultBindingBuilder<T>(Key.get(interfaceType), this.injector);
    }

    @Override
    public <T> BindingBuilder<T> bind(Key<T> key) {
        return new DefaultBindingBuilder<T>(key, this.injector);
    }

    @Override
    @Deprecated
    public <T> ListBuilder<T> bindList(String bindingName) {
        return this.bindList(Object.class, bindingName);
    }

    @Override
    public <T> ListBuilder<T> bindList(Class<T> valueType) {
        return this.bindList(valueType, null);
    }

    @Override
    public <T> ListBuilder<T> bindList(Class<T> valueType, String bindingName) {
        return new DefaultListBuilder<T>(Key.getListOf(valueType, bindingName), this.injector);
    }

    @Override
    @Deprecated
    public <T> MapBuilder<T> bindMap(String bindingName) {
        return this.bindMap(Object.class, bindingName);
    }

    @Override
    public <T> MapBuilder<T> bindMap(Class<T> valueType) {
        return this.bindMap(valueType, null);
    }

    @Override
    public <T> MapBuilder<T> bindMap(Class<T> valueType, String bindingName) {
        return new DefaultMapBuilder<T>(Key.getMapOf(String.class, valueType, bindingName), this.injector);
    }

    @Override
    public <T> DecoratorBuilder<T> decorate(Class<T> interfaceType) {
        return new DefaultDecoratorBuilder<T>(Key.get(interfaceType), this.injector);
    }

    @Override
    public <T> DecoratorBuilder<T> decorate(Key<T> key) {
        return new DefaultDecoratorBuilder<T>(key, this.injector);
    }
}

