/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;

public class StringUtils {
    private static StringUtils sharedInstance;

    public static StringUtils getInstance() {
        if (null == sharedInstance) {
            sharedInstance = new StringUtils();
        }
        return sharedInstance;
    }

    public String formatVariableName(String variableName) {
        if (NameValidationHelper.getInstance().isReservedJavaKeyword(variableName)) {
            return "_" + variableName;
        }
        return variableName;
    }

    public String stripPackageName(String fullyQualifiedClassName) {
        return Util.stripPackageName(fullyQualifiedClassName);
    }

    public String stripClass(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        int lastDot = aString.lastIndexOf(46);
        if (-1 == lastDot) {
            return "";
        }
        return aString.substring(0, lastDot);
    }

    public String capitalized(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char c = Character.toUpperCase(name.charAt(0));
        return name.length() == 1 ? Character.toString(c) : c + name.substring(1);
    }

    public static String uncapitalized(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        char c = Character.toLowerCase(aString.charAt(0));
        return aString.length() == 1 ? Character.toString(c) : c + aString.substring(1);
    }

    public String capitalizedAsConstant(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        name = Util.specialCharsToJava(name);
        char[] charArray = name.toCharArray();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < charArray.length; ++i) {
            char prevChar;
            if (Character.isUpperCase(charArray[i]) && i != 0 && Character.isLowerCase(prevChar = charArray[i - 1])) {
                buffer.append("_");
            }
            buffer.append(Character.toUpperCase(charArray[i]));
        }
        return buffer.toString();
    }

    public String pluralize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.endsWith("s") || str.endsWith("x")) {
            return str + "es";
        }
        if (str.endsWith("y")) {
            return str.substring(0, str.length() - 1) + "ies";
        }
        return str + "s";
    }

    public String stripGeneric(String str) {
        if (str == null) {
            return null;
        }
        int start = str.indexOf(60);
        if (start == -1) {
            return str;
        }
        int end2 = str.lastIndexOf(62);
        if (end2 == -1) {
            return str;
        }
        if (end2 == str.length() - 1) {
            return str.substring(0, start);
        }
        return str.substring(0, start) + str.substring(end2 + 1);
    }

    public String replaceWildcardInStringWithString(String wildcard, String pattern, String replacement) {
        if (pattern == null || wildcard == null) {
            return pattern;
        }
        StringBuilder buffer = new StringBuilder();
        int lastPos = 0;
        int wildCardPos = pattern.indexOf(wildcard);
        while (wildCardPos != -1) {
            if (lastPos != wildCardPos) {
                buffer.append(pattern.substring(lastPos, wildCardPos));
            }
            buffer.append(replacement);
            wildCardPos = pattern.indexOf(wildcard, lastPos += wildCardPos + wildcard.length());
        }
        if (lastPos < pattern.length()) {
            buffer.append(pattern.substring(lastPos));
        }
        return buffer.toString();
    }
}

