/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.dialog.FileDeletedDialog;
import org.apache.cayenne.project.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileChangeTracker
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectFileChangeTracker.class);
    private static final long DEFAULT_DELAY = 4000L;
    protected final Map<URI, FileInfo> files = new ConcurrentHashMap<URI, FileInfo>();
    protected final ProjectController mediator;
    protected boolean paused;
    protected boolean isShownChangeDialog;
    protected boolean isShownRemoveDialog;

    public ProjectFileChangeTracker(ProjectController mediator) {
        this.mediator = mediator;
        this.setName("cayenne-modeler-file-change-tracker");
    }

    public void reconfigure() {
        this.pauseWatching();
        this.removeAllFiles();
        Project project = this.mediator.getProject();
        if (project != null && project.getConfigurationResource() != null) {
            try {
                this.addFile(project.getConfigurationResource().getURL().toURI());
                for (DataMap dm : ((DataChannelDescriptor)project.getRootNode()).getDataMaps()) {
                    if (dm.getConfigurationSource() == null) continue;
                    this.addFile(dm.getConfigurationSource().getURL().toURI());
                }
            }
            catch (URISyntaxException ex) {
                throw new CayenneRuntimeException("Unable to start change tracker", (Throwable)ex, new Object[0]);
            }
        }
        this.resumeWatching();
    }

    protected void doOnChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectFileChangeTracker.this.isShownChangeDialog = true;
                if (ProjectFileChangeTracker.this.showConfirmation("One or more project files were changed by external program. Do you want to load the changes?")) {
                    if (ProjectFileChangeTracker.this.mediator.getProject() != null) {
                        try {
                            File fileDirectory = new File(ProjectFileChangeTracker.this.mediator.getProject().getConfigurationResource().getURL().toURI());
                            Application.getInstance().getActionManager().getAction(OpenProjectAction.class).openProject(fileDirectory);
                        }
                        catch (URISyntaxException ex) {
                            throw new CayenneRuntimeException("Unable to open file %s", (Throwable)ex, ProjectFileChangeTracker.this.mediator.getProject().getConfigurationResource().getURL());
                        }
                    }
                } else {
                    ProjectFileChangeTracker.this.mediator.setDirty(true);
                }
                ProjectFileChangeTracker.this.isShownChangeDialog = false;
            }
        });
    }

    protected void doOnRemove() {
        if (this.mediator.getProject() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectFileChangeTracker.this.isShownRemoveDialog = true;
                    FileDeletedDialog dialog = new FileDeletedDialog(Application.getFrame());
                    dialog.show();
                    if (dialog.shouldSave()) {
                        Application.getInstance().getActionManager().getAction(SaveAction.class).performAction(null);
                    } else if (dialog.shouldClose()) {
                        Application.getInstance().getFrameController().projectClosedAction();
                    } else {
                        ProjectFileChangeTracker.this.mediator.setDirty(true);
                    }
                    ProjectFileChangeTracker.this.isShownRemoveDialog = false;
                }
            });
        }
    }

    private boolean showConfirmation(String message) {
        return 0 == JOptionPane.showConfirmDialog(Application.getFrame(), message, "File changed", 0, 3);
    }

    public void addFile(URI location) {
        try {
            this.files.put(location, new FileInfo(location));
        }
        catch (SecurityException e) {
            LOGGER.error("SecurityException adding file " + location, e);
        }
    }

    public void removeFile(String location) {
        this.files.remove(URI.create(location));
    }

    public void removeAllFiles() {
        this.files.clear();
    }

    protected void check() {
        if (this.paused) {
            return;
        }
        boolean hasChanges = false;
        boolean hasDeletions = false;
        Iterator<FileInfo> it = this.files.values().iterator();
        while (it.hasNext()) {
            boolean fileExists;
            FileInfo fi = it.next();
            try {
                fileExists = fi.getFile().exists();
            }
            catch (SecurityException e) {
                LOGGER.error("SecurityException checking file " + fi.getFile().getPath(), e);
                continue;
            }
            if (fileExists) {
                long l = fi.getFile().lastModified();
                if (l <= fi.getLastModified()) continue;
                fi.setLastModified(l);
                hasChanges = true;
                continue;
            }
            if (fi.getLastModified() == -1L) continue;
            hasDeletions = true;
            it.remove();
        }
        if (hasDeletions && !this.isShownRemoveDialog) {
            this.doOnRemove();
        } else if (hasChanges && !this.isShownChangeDialog) {
            this.doOnChange();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(4000L);
                this.check();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void pauseWatching() {
        this.paused = true;
    }

    public void resumeWatching() {
        this.paused = false;
    }

    protected static class FileInfo {
        private final File file;
        private long lastModified;

        protected FileInfo(URI location) {
            this.file = new File(location);
            this.lastModified = this.file.exists() ? this.file.lastModified() : -1L;
        }

        protected File getFile() {
            return this.file;
        }

        protected long getLastModified() {
            return this.lastModified;
        }

        protected void setLastModified(long l) {
            this.lastModified = l;
        }
    }
}

