/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.dialog.pref.TemplateCreator;
import org.apache.cayenne.modeler.dialog.pref.TemplatePreferencesView;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatePreferences
extends CayenneController {
    protected TemplatePreferencesView view = new TemplatePreferencesView();
    protected CayennePreferenceEditor editor;
    protected List<FSPath> templateEntries;
    protected ObjectBinding tableBinding;
    private static Logger logger = LoggerFactory.getLogger(TemplatePreferences.class);

    public TemplatePreferences(PreferenceDialog parent) {
        super(parent);
        PreferenceEditor editor = parent.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
        }
        this.templateEntries = new ArrayList<FSPath>();
        try {
            String[] keys;
            for (String key : keys = this.getTemplatePreferences().childrenNames()) {
                this.templateEntries.add((FSPath)this.application.getCayenneProjectPreferences().getProjectDetailObject(FSPath.class, this.getTemplatePreferences().node(key)));
            }
        }
        catch (BackingStoreException e) {
            logger.warn("Error reading preferences");
        }
        this.initBindings();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected Preferences getTemplatePreferences() {
        return this.application.getPreferencesNode(CodeTemplateManager.class, "codeTemplateManager");
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getAddButton(), "addTemplateAction()");
        builder.bindToAction(this.view.getRemoveButton(), "removeTemplateAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(builder);
        tableBuilder.addColumn("Name", "#item.key", String.class, false, "XXXXXXXXXXXXXXX");
        tableBuilder.addColumn("Path", "#item.path", String.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableBuilder.bindToTable(this.view.getTable(), "templateEntries").updateView();
    }

    public List<FSPath> getTemplateEntries() {
        return this.templateEntries;
    }

    public PreferenceEditor getEditor() {
        return this.editor;
    }

    public void addTemplateAction() {
        FSPath path = new TemplateCreator(this).startupAction();
        if (path != null) {
            int len = this.templateEntries.size();
            this.templateEntries.add(path);
            ((AbstractTableModel)this.view.getTable().getModel()).fireTableRowsInserted(len, len);
        }
    }

    public void removeTemplateAction() {
        int selected = this.view.getTable().getSelectedRow();
        if (selected < 0) {
            return;
        }
        Object key = ((AbstractTableModel)this.view.getTable().getModel()).getValueAt(selected, 0);
        this.editor.getRemovedNode().add(this.getTemplatePreferences().node((String)key));
        this.templateEntries.remove(selected);
        ((AbstractTableModel)this.view.getTable().getModel()).fireTableRowsDeleted(selected, selected);
    }
}

