/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.map.DbAttribute;
import org.apache.commons.collections.Factory;

public abstract class BatchQueryRow {
    protected ObjectId objectId;
    protected Map<String, Object> qualifier;

    public BatchQueryRow(ObjectId objectId, Map<String, Object> qualifier) {
        this.objectId = objectId;
        this.qualifier = qualifier;
    }

    public abstract Object getValue(int var1);

    public Map<String, Object> getQualifier() {
        return this.qualifier;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    protected Object getValue(Map<String, Object> valueMap, DbAttribute attribute) {
        Object value = valueMap.get(attribute.getName());
        if (value instanceof Factory) {
            value = ((Factory)value).create();
            valueMap.put(attribute.getName(), value);
            if (attribute.isPrimaryKey()) {
                if (value == null) {
                    String name = attribute.getEntity() != null ? attribute.getEntity().getName() : "<null>";
                    throw new CayenneRuntimeException("Failed to generate PK: %s.%s", name, attribute.getName());
                }
                ObjectId id = this.getObjectId();
                if (id != null) {
                    id.getReplacementIdMap().put(attribute.getName(), value);
                }
            }
        }
        return value;
    }
}

