package org.apache.cayenne.testdo.cay_2521.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.cay_2521.Issue;
import org.apache.cayenne.testdo.cay_2521.Location;

/**
 * Class _Team was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Team extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String ID_PK_COLUMN = "id";

    public static final Property<List<Location>> LOCATIONS = Property.create("locations", List.class);
    public static final Property<Location> HOME_LOCATION = Property.create("homeLocation", Location.class);
    public static final Property<List<Issue>> ISSUES = Property.create("issues", List.class);


    protected Object locations;
    protected Object homeLocation;
    protected Object issues;

    public void addToLocations(Location obj) {
        addToManyTarget("locations", obj, true);
    }

    public void removeFromLocations(Location obj) {
        removeToManyTarget("locations", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Location> getLocations() {
        return (List<Location>)readProperty("locations");
    }

    public void setHomeLocation(Location homeLocation) {
        setToOneTarget("homeLocation", homeLocation, true);
    }

    public Location getHomeLocation() {
        return (Location)readProperty("homeLocation");
    }

    public void addToIssues(Issue obj) {
        addToManyTarget("issues", obj, true);
    }

    public void removeFromIssues(Issue obj) {
        removeToManyTarget("issues", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Issue> getIssues() {
        return (List<Issue>)readProperty("issues");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "locations":
                return this.locations;
            case "homeLocation":
                return this.homeLocation;
            case "issues":
                return this.issues;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "locations":
                this.locations = val;
                break;
            case "homeLocation":
                this.homeLocation = val;
                break;
            case "issues":
                this.issues = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.locations);
        out.writeObject(this.homeLocation);
        out.writeObject(this.issues);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.locations = in.readObject();
        this.homeLocation = in.readObject();
        this.issues = in.readObject();
    }

}
