package org.apache.cayenne.testdo.testmap.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.testdo.testmap.ROArtist;

/**
 * Class _CompoundPaintingLongNames was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _CompoundPaintingLongNames extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String PAINTING_ID_PK_COLUMN = "PAINTING_ID";

    public static final Property<String> ARTIST_LONG_NAME = Property.create("artistLongName", String.class);
    public static final Property<BigDecimal> ESTIMATED_PRICE = Property.create("estimatedPrice", BigDecimal.class);
    public static final Property<String> GALLERY_LONG_NAME = Property.create("galleryLongName", String.class);
    public static final Property<String> PAINTING_DESCRIPTION = Property.create("paintingDescription", String.class);
    public static final Property<String> PAINTING_TITLE = Property.create("paintingTitle", String.class);
    public static final Property<String> TEXT_LONG_REVIEW = Property.create("textLongReview", String.class);
    public static final Property<Artist> TO_ARTIST = Property.create("toArtist", Artist.class);
    public static final Property<ROArtist> TO_ARTIST1 = Property.create("toArtist1", ROArtist.class);
    public static final Property<Gallery> TO_GALLERY = Property.create("toGallery", Gallery.class);
    public static final Property<PaintingInfo> TO_PAINTING_INFO = Property.create("toPaintingInfo", PaintingInfo.class);

    protected String artistLongName;
    protected BigDecimal estimatedPrice;
    protected String galleryLongName;
    protected String paintingDescription;
    protected String paintingTitle;
    protected String textLongReview;

    protected Object toArtist;
    protected Object toArtist1;
    protected Object toGallery;
    protected Object toPaintingInfo;

    public void setArtistLongName(String artistLongName) {
        beforePropertyWrite("artistLongName", this.artistLongName, artistLongName);
        this.artistLongName = artistLongName;
    }

    public String getArtistLongName() {
        beforePropertyRead("artistLongName");
        return this.artistLongName;
    }

    public void setEstimatedPrice(BigDecimal estimatedPrice) {
        beforePropertyWrite("estimatedPrice", this.estimatedPrice, estimatedPrice);
        this.estimatedPrice = estimatedPrice;
    }

    public BigDecimal getEstimatedPrice() {
        beforePropertyRead("estimatedPrice");
        return this.estimatedPrice;
    }

    public void setGalleryLongName(String galleryLongName) {
        beforePropertyWrite("galleryLongName", this.galleryLongName, galleryLongName);
        this.galleryLongName = galleryLongName;
    }

    public String getGalleryLongName() {
        beforePropertyRead("galleryLongName");
        return this.galleryLongName;
    }

    public void setPaintingDescription(String paintingDescription) {
        beforePropertyWrite("paintingDescription", this.paintingDescription, paintingDescription);
        this.paintingDescription = paintingDescription;
    }

    public String getPaintingDescription() {
        beforePropertyRead("paintingDescription");
        return this.paintingDescription;
    }

    public void setPaintingTitle(String paintingTitle) {
        beforePropertyWrite("paintingTitle", this.paintingTitle, paintingTitle);
        this.paintingTitle = paintingTitle;
    }

    public String getPaintingTitle() {
        beforePropertyRead("paintingTitle");
        return this.paintingTitle;
    }

    public void setTextLongReview(String textLongReview) {
        beforePropertyWrite("textLongReview", this.textLongReview, textLongReview);
        this.textLongReview = textLongReview;
    }

    public String getTextLongReview() {
        beforePropertyRead("textLongReview");
        return this.textLongReview;
    }

    public void setToArtist(Artist toArtist) {
        setToOneTarget("toArtist", toArtist, true);
    }

    public Artist getToArtist() {
        return (Artist)readProperty("toArtist");
    }

    public void setToArtist1(ROArtist toArtist1) {
        setToOneTarget("toArtist1", toArtist1, true);
    }

    public ROArtist getToArtist1() {
        return (ROArtist)readProperty("toArtist1");
    }

    public void setToGallery(Gallery toGallery) {
        setToOneTarget("toGallery", toGallery, true);
    }

    public Gallery getToGallery() {
        return (Gallery)readProperty("toGallery");
    }

    public void setToPaintingInfo(PaintingInfo toPaintingInfo) {
        setToOneTarget("toPaintingInfo", toPaintingInfo, true);
    }

    public PaintingInfo getToPaintingInfo() {
        return (PaintingInfo)readProperty("toPaintingInfo");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "artistLongName":
                return this.artistLongName;
            case "estimatedPrice":
                return this.estimatedPrice;
            case "galleryLongName":
                return this.galleryLongName;
            case "paintingDescription":
                return this.paintingDescription;
            case "paintingTitle":
                return this.paintingTitle;
            case "textLongReview":
                return this.textLongReview;
            case "toArtist":
                return this.toArtist;
            case "toArtist1":
                return this.toArtist1;
            case "toGallery":
                return this.toGallery;
            case "toPaintingInfo":
                return this.toPaintingInfo;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "artistLongName":
                this.artistLongName = (String)val;
                break;
            case "estimatedPrice":
                this.estimatedPrice = (BigDecimal)val;
                break;
            case "galleryLongName":
                this.galleryLongName = (String)val;
                break;
            case "paintingDescription":
                this.paintingDescription = (String)val;
                break;
            case "paintingTitle":
                this.paintingTitle = (String)val;
                break;
            case "textLongReview":
                this.textLongReview = (String)val;
                break;
            case "toArtist":
                this.toArtist = val;
                break;
            case "toArtist1":
                this.toArtist1 = val;
                break;
            case "toGallery":
                this.toGallery = val;
                break;
            case "toPaintingInfo":
                this.toPaintingInfo = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.artistLongName);
        out.writeObject(this.estimatedPrice);
        out.writeObject(this.galleryLongName);
        out.writeObject(this.paintingDescription);
        out.writeObject(this.paintingTitle);
        out.writeObject(this.textLongReview);
        out.writeObject(this.toArtist);
        out.writeObject(this.toArtist1);
        out.writeObject(this.toGallery);
        out.writeObject(this.toPaintingInfo);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.artistLongName = (String)in.readObject();
        this.estimatedPrice = (BigDecimal)in.readObject();
        this.galleryLongName = (String)in.readObject();
        this.paintingDescription = (String)in.readObject();
        this.paintingTitle = (String)in.readObject();
        this.textLongReview = (String)in.readObject();
        this.toArtist = in.readObject();
        this.toArtist1 = in.readObject();
        this.toGallery = in.readObject();
        this.toPaintingInfo = in.readObject();
    }

}
