/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.id;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;

public class EntityIdCoder {
    static final String ID_SEPARATOR = ":";
    static final String TEMP_ID_PREFIX = ".";
    private static final int TEMP_PREFIX_LENGTH = ".".length();
    private String entityName;
    private SortedMap<String, Converter<?>> converters;
    private int idSize;

    public static String getEntityName(String id) {
        int separator = id.indexOf(ID_SEPARATOR);
        if (separator <= 0 || separator == id.length() - 1) {
            throw new IllegalArgumentException("Invalid String id: " + id);
        }
        String name = id.substring(0, separator);
        if (name.startsWith(TEMP_ID_PREFIX)) {
            name = name.substring(TEMP_PREFIX_LENGTH);
        }
        return name;
    }

    public EntityIdCoder(ObjEntity entity) {
        this.entityName = entity.getName();
        this.converters = new TreeMap();
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (!attribute.isPrimaryKey()) continue;
            this.converters.put(attribute.getDbAttributeName(), this.create(attribute.getJavaClass()));
        }
        for (ObjAttribute attribute : entity.getDbEntity().getPrimaryKeys()) {
            if (this.converters.containsKey(attribute.getName())) continue;
            String type = TypesMapping.getJavaBySqlType((int)attribute.getType());
            try {
                this.converters.put(attribute.getName(), this.create(Util.getJavaClass((String)type)));
            }
            catch (ClassNotFoundException e) {
                throw new CayenneRuntimeException("Can't instantiate class " + type, (Throwable)e, new Object[0]);
            }
        }
        if (this.converters.isEmpty()) {
            throw new IllegalArgumentException("Entity has no PK defined: " + entity.getName());
        }
        this.idSize = (int)Math.ceil((double)this.converters.size() / 0.75);
    }

    public String toStringId(ObjectId id) {
        if (id.isTemporary() && !id.isReplacementIdAttached()) {
            return this.toTempIdString(id);
        }
        return this.toPermIdString(id);
    }

    private String toTempIdString(ObjectId id) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(TEMP_ID_PREFIX);
        buffer.append(id.getEntityName());
        buffer.append(ID_SEPARATOR);
        for (byte b : id.getKey()) {
            IDUtil.appendFormattedByte((Appendable)buffer, (byte)b);
        }
        return buffer.toString();
    }

    private String toPermIdString(ObjectId id) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(id.getEntityName());
        Map idValues = id.getIdSnapshot();
        for (Map.Entry<String, Converter<?>> entry : this.converters.entrySet()) {
            Object value = idValues.get(entry.getKey());
            buffer.append(ID_SEPARATOR).append(entry.getValue().toUuid(value));
        }
        return buffer.toString();
    }

    public ObjectId toObjectId(String stringId) {
        if (stringId.startsWith(TEMP_ID_PREFIX)) {
            String idValues = stringId.substring(this.entityName.length() + 1 + TEMP_PREFIX_LENGTH);
            return new ObjectId(this.entityName, this.decodeTemp(idValues));
        }
        String idValues = stringId.substring(this.entityName.length() + 1);
        if (this.converters.size() == 1) {
            String decoded;
            Map.Entry<String, Converter<?>> entry = this.converters.entrySet().iterator().next();
            try {
                decoded = URLDecoder.decode(idValues, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
            return new ObjectId(this.entityName, entry.getKey(), entry.getValue().fromStringId(decoded));
        }
        HashMap idMap = new HashMap(this.idSize);
        StringTokenizer toks = new StringTokenizer(idValues, ID_SEPARATOR);
        if (toks.countTokens() != this.converters.size()) {
            throw new IllegalArgumentException("Invalid String ID for entity " + this.entityName + ": " + idValues);
        }
        for (Map.Entry<String, Converter<?>> entry : this.converters.entrySet()) {
            String decoded;
            String value = toks.nextToken();
            try {
                decoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
            idMap.put(entry.getKey(), entry.getValue().fromStringId(decoded));
        }
        return new ObjectId(this.entityName, idMap);
    }

    private byte[] decodeTemp(String byteString) {
        byte[] bytes = new byte[byteString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int index = i * 2;
            char c1 = byteString.charAt(index);
            char c2 = byteString.charAt(index + 1);
            bytes[i] = (byte)((Character.digit((int)c1, 16) << 4) + Character.digit((int)c2, 16));
        }
        return bytes;
    }

    private Converter<?> create(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        if (Long.class.isAssignableFrom(type)) {
            return Long::valueOf;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return Integer::valueOf;
        }
        if (String.class.isAssignableFrom(type)) {
            return stringId -> stringId;
        }
        throw new IllegalArgumentException("Unsupported ID type: " + type.getName());
    }

    static interface Converter<T> {
        default public String toUuid(Object value) {
            try {
                return URLEncoder.encode(String.valueOf(value), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
        }

        public T fromStringId(String var1);
    }
}

