/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.derby;

import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.map.DbEntity;

public class DerbyPkGenerator
extends OraclePkGenerator {
    public DerbyPkGenerator() {
    }

    DerbyPkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    protected String sequenceName(DbEntity entity) {
        return super.sequenceName(entity).toUpperCase();
    }

    @Override
    protected String selectNextValQuery(String pkGeneratingSequenceName) {
        return "VALUES (NEXT VALUE FOR " + pkGeneratingSequenceName + ")";
    }

    @Override
    protected String selectAllSequencesQuery() {
        return "SELECT SEQUENCENAME FROM SYS.SYSSEQUENCES";
    }

    @Override
    protected String dropSequenceString(DbEntity entity) {
        return "DROP SEQUENCE " + this.sequenceName(entity) + " RESTRICT";
    }

    @Override
    protected String createSequenceString(DbEntity entity) {
        return "CREATE SEQUENCE " + this.sequenceName(entity) + " AS BIGINT START WITH " + this.pkStartValue + " INCREMENT BY " + this.getPkCacheSize() + " NO MAXVALUE NO CYCLE";
    }
}

