/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.util.Map;
import java.util.TreeMap;
import org.apache.cayenne.configuration.xml.DbEntityHandler;
import org.apache.cayenne.configuration.xml.DbRelationshipHandler;
import org.apache.cayenne.configuration.xml.EmbeddableHandler;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.configuration.xml.ObjEntityHandler;
import org.apache.cayenne.configuration.xml.ObjRelationshipHandler;
import org.apache.cayenne.configuration.xml.ProcedureHandler;
import org.apache.cayenne.configuration.xml.QueryDescriptorHandler;
import org.apache.cayenne.map.DataMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DataMapHandler
extends NamespaceAwareNestedTagHandler {
    private static final String DATA_MAP_TAG = "data-map";
    private static final String PROPERTY_TAG = "property";
    private static final String DB_ENTITY_TAG = "db-entity";
    private static final String OBJ_ENTITY_TAG = "obj-entity";
    private static final String DB_RELATIONSHIP_TAG = "db-relationship";
    private static final String OBJ_RELATIONSHIP_TAG = "obj-relationship";
    private static final String EMBEDDABLE_TAG = "embeddable";
    private static final String PROCEDURE_TAG = "procedure";
    private static final String QUERY_TAG = "query";
    public static final String TRUE = "true";
    private DataMap dataMap;
    private Map<String, Object> mapProperties;

    public DataMapHandler(NamespaceAwareNestedTagHandler parentHandler) {
        super(parentHandler);
    }

    public DataMapHandler(LoaderContext loaderContext) {
        super(loaderContext);
        this.setTargetNamespace("http://cayenne.apache.org/schema/10/modelMap");
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "property": {
                this.addProperty(attributes);
                return true;
            }
            case "data-map": {
                this.dataMap = new DataMap();
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI.equals(this.targetNamespace)) {
            switch (localName) {
                case "db-entity": {
                    return new DbEntityHandler(this, this.dataMap);
                }
                case "obj-entity": {
                    return new ObjEntityHandler(this, this.dataMap);
                }
                case "db-relationship": {
                    return new DbRelationshipHandler(this, this.dataMap);
                }
                case "obj-relationship": {
                    return new ObjRelationshipHandler(this, this.dataMap);
                }
                case "procedure": {
                    return new ProcedureHandler(this, this.dataMap);
                }
                case "query": {
                    return new QueryDescriptorHandler(this, this.dataMap);
                }
                case "embeddable": {
                    return new EmbeddableHandler(this, this.dataMap);
                }
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    @Override
    protected void beforeScopeEnd() {
        this.dataMap.initWithProperties(this.mapProperties);
        this.loaderContext.dataMapLoaded(this.dataMap);
    }

    private void addProperty(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (null == name) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property name.");
        }
        String value = attributes.getValue("value");
        if (null == value) {
            throw new SAXException("MapLoader::processStartDataMapProperty(), no property value.");
        }
        if ("name".equals(name)) {
            this.dataMap.setName(value);
            return;
        }
        if (this.mapProperties == null) {
            this.mapProperties = new TreeMap<String, Object>();
        }
        this.mapProperties.put(name, value);
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }
}

