/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class ClassGeneratorResourceLoader
extends FileResourceLoader {
    private Path root;

    public void init(ExtProperties configuration) {
        String rootPathStr = configuration.getString("root");
        if (rootPathStr != null) {
            this.root = Paths.get(rootPathStr, new String[0]);
        }
    }

    public synchronized Reader getResourceReader(String name, String charset) throws ResourceNotFoundException {
        Reader stream = this.loadFromThreadClassLoader(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromThisClassLoader(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromRelativePath(name);
        if (stream != null) {
            return stream;
        }
        stream = this.loadFromAbsPath(name);
        if (stream != null) {
            return stream;
        }
        throw new ResourceNotFoundException("Couldn't find resource '" + name + "'. Searched filesystem path and classpath");
    }

    protected Reader loadFromRelativePath(String name) {
        if (this.root != null) {
            Path absolutePath = this.root.resolve(name).normalize();
            return this.loadFromAbsPath(absolutePath.toString());
        }
        return null;
    }

    protected Reader loadFromAbsPath(String name) {
        try {
            File file = new File(name);
            return file.canRead() ? new BufferedReader(new FileReader(file.getAbsolutePath())) : null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    protected Reader loadFromThreadClassLoader(String name) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        return stream != null ? new InputStreamReader(stream) : null;
    }

    protected Reader loadFromThisClassLoader(String name) {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(name);
        return stream != null ? new InputStreamReader(stream) : null;
    }
}

