/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.OptimisticLockException;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.JDBCResultIterator;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;

public class BatchAction
extends BaseSQLAction {
    protected boolean runningAsBatch;
    protected BatchQuery query;
    protected RowDescriptor keyRowDescriptor;

    private static void bind(DbAdapter adapter, PreparedStatement statement, DbAttributeBinding[] bindings) throws Exception {
        for (DbAttributeBinding b : bindings) {
            if (b.isExcluded()) continue;
            adapter.bindParameter(statement, b);
        }
    }

    public BatchAction(BatchQuery query, DataNode dataNode, boolean runningAsBatch) {
        super(dataNode);
        this.query = query;
        this.runningAsBatch = runningAsBatch;
    }

    public BatchQuery getQuery() {
        return this.query;
    }

    @Override
    public void performAction(Connection connection, OperationObserver observer) throws Exception {
        boolean generatesKeys;
        BatchTranslator translator = this.createTranslator();
        boolean isBatch = this.canRunAsBatch();
        boolean bl = generatesKeys = this.hasGeneratedKeys() && this.supportsGeneratedKeys(isBatch);
        if (isBatch) {
            this.runAsBatch(connection, translator, observer, generatesKeys);
        } else {
            this.runAsIndividualQueries(connection, translator, observer, generatesKeys);
        }
    }

    protected boolean canRunAsBatch() {
        if (!this.runningAsBatch || this.query.getRows().size() <= 1) {
            return false;
        }
        if (this.hasGeneratedKeys()) {
            return this.supportsGeneratedKeys(true) && !this.dataNode.getEntityResolver().getEntitySorter().isReflexive(this.query.getDbEntity());
        }
        return true;
    }

    protected BatchTranslator createTranslator() {
        return this.dataNode.batchTranslator(this.query, null);
    }

    protected void runAsBatch(Connection con, BatchTranslator translator, OperationObserver delegate, boolean generatesKeys) throws Exception {
        String sql = translator.getSql();
        JdbcEventLogger logger = this.dataNode.getJdbcEventLogger();
        boolean isLoggable = logger.isLoggable();
        logger.log(sql);
        DbAdapter adapter = this.dataNode.getAdapter();
        try (PreparedStatement statement = this.prepareStatement(con, sql, adapter, generatesKeys);){
            for (BatchQueryRow row : this.query.getRows()) {
                ParameterBinding[] bindings = translator.updateBindings(row);
                logger.logQueryParameters("batch bind", bindings);
                BatchAction.bind(adapter, statement, (DbAttributeBinding[])bindings);
                statement.addBatch();
            }
            int[] results = statement.executeBatch();
            delegate.nextBatchCount(this.query, results);
            if (generatesKeys) {
                this.processGeneratedKeys((Statement)statement, delegate, this.query.getRows());
            }
            if (isLoggable) {
                int totalUpdateCount = 0;
                for (int result : results) {
                    if (result < 0) {
                        totalUpdateCount = -2;
                        break;
                    }
                    totalUpdateCount += result;
                }
                logger.logUpdateCount(totalUpdateCount);
            }
        }
    }

    protected void runAsIndividualQueries(Connection connection, BatchTranslator translator, OperationObserver delegate, boolean generatesKeys) throws SQLException, Exception {
        if (this.query.getRows().isEmpty()) {
            return;
        }
        JdbcEventLogger logger = this.dataNode.getJdbcEventLogger();
        boolean useOptimisticLock = this.query.isUsingOptimisticLocking();
        String queryStr = translator.getSql();
        logger.log(queryStr);
        DbAdapter adapter = this.dataNode.getAdapter();
        try (PreparedStatement statement = this.prepareStatement(connection, queryStr, adapter, generatesKeys);){
            for (BatchQueryRow row : this.query.getRows()) {
                ParameterBinding[] bindings = translator.updateBindings(row);
                logger.logQueryParameters("bind", bindings);
                BatchAction.bind(adapter, statement, (DbAttributeBinding[])bindings);
                int updated = statement.executeUpdate();
                if (useOptimisticLock && updated != 1) {
                    throw new OptimisticLockException(row.getObjectId(), this.query.getDbEntity(), queryStr, row.getQualifier());
                }
                delegate.nextCount(this.query, updated);
                if (generatesKeys) {
                    this.processGeneratedKeys((Statement)statement, delegate, row);
                }
                logger.logUpdateCount(updated);
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, String queryStr, DbAdapter adapter, boolean generatedKeys) throws SQLException {
        return generatedKeys ? connection.prepareStatement(queryStr, 1) : connection.prepareStatement(queryStr);
    }

    protected boolean supportsGeneratedKeys(boolean isBatch) {
        return isBatch ? this.dataNode.getAdapter().supportsGeneratedKeysForBatchInserts() : this.dataNode.getAdapter().supportsGeneratedKeys();
    }

    protected boolean hasGeneratedKeys() {
        if (this.query instanceof InsertBatchQuery) {
            for (DbAttribute attr : this.query.getDbEntity().getGeneratedAttributes()) {
                if (!attr.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    protected void processGeneratedKeys(Statement statement, OperationObserver observer, BatchQueryRow row) throws SQLException {
        this.processGeneratedKeys(statement, observer, Collections.singletonList(row));
    }

    protected void processGeneratedKeys(Statement statement, OperationObserver observer, List<BatchQueryRow> rows) throws SQLException {
        ResultSet keysRS = statement.getGeneratedKeys();
        RowDescriptorBuilder builder = new RowDescriptorBuilder();
        if (this.keyRowDescriptor == null) {
            Collection<DbAttribute> generated = this.query.getDbEntity().getGeneratedAttributes();
            if (generated.size() == 1 && keysRS.getMetaData().getColumnCount() == 1) {
                DbAttribute key = generated.iterator().next();
                ColumnDescriptor[] columns = new ColumnDescriptor[]{new ColumnDescriptor(keysRS.getMetaData(), 1)};
                columns[0].setJdbcType(key.getType());
                columns[0].setJavaClass(TypesMapping.getJavaBySqlType(key));
                builder.setColumns(columns);
            } else {
                builder.setResultSet(keysRS);
            }
            this.keyRowDescriptor = builder.getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
        }
        RowReader<?> rowReader = this.dataNode.rowReader(this.keyRowDescriptor, this.query.getMetaData(this.dataNode.getEntityResolver()), Collections.emptyMap());
        JDBCResultIterator iterator = new JDBCResultIterator(null, keysRS, rowReader);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>(rows.size());
        for (BatchQueryRow row : rows) {
            objectIds.add(row.getObjectId());
        }
        observer.nextGeneratedRows((Query)this.query, iterator, objectIds);
    }
}

