/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.ExpressionTrait;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.EqualNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NotNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;

public class ExpressionNodeBuilder
implements ExpressionTrait {
    private final NodeBuilder left;

    ExpressionNodeBuilder(NodeBuilder left) {
        this.left = left;
    }

    public ExpressionNodeBuilder and(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "AND"));
    }

    public ExpressionNodeBuilder or(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "OR"));
    }

    @Override
    public ExpressionNodeBuilder plus(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "+"));
    }

    @Override
    public ExpressionNodeBuilder minus(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "-"));
    }

    @Override
    public ExpressionNodeBuilder mul(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "*"));
    }

    @Override
    public ExpressionNodeBuilder div(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "/"));
    }

    @Override
    public ExpressionNodeBuilder eq(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "="));
    }

    @Override
    public ExpressionNodeBuilder lt(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "<"));
    }

    @Override
    public ExpressionNodeBuilder gt(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, ">"));
    }

    @Override
    public ExpressionNodeBuilder lte(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, "<="));
    }

    @Override
    public ExpressionNodeBuilder gte(NodeBuilder operand) {
        return new ExpressionNodeBuilder(new ExpNodeBuilder(operand, ">="));
    }

    public ExpressionNodeBuilder not() {
        return new ExpressionNodeBuilder(() -> {
            NotNode and = new NotNode();
            and.addChild(this.left.build());
            return and;
        });
    }

    @Override
    public Node build() {
        return this.left.build();
    }

    private class ExpNodeBuilder
    implements NodeBuilder {
        private final NodeBuilder operand;
        private final String operation;

        public ExpNodeBuilder(NodeBuilder operand, String operation) {
            this.operand = operand;
            this.operation = operation;
        }

        @Override
        public Node build() {
            ExpressionNode node = this.operation.equals("=") ? new EqualNode() : new OpExpressionNode(this.operation);
            node.addChild(ExpressionNodeBuilder.this.left.build());
            node.addChild(this.operand.build());
            return node;
        }
    }
}

