/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.UpgradeCayennePreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerPreferences
implements PreferenceChangeListener {
    private static Preferences cayennePrefs;
    private static final Logger logObj;
    public static final String LOGFILE_NAME = "modeler.log";
    public static final int LAST_PROJ_FILES_SIZE = 12;
    public static final String EDITOR_LOGFILE_ENABLED = "logfileEnabled";
    public static final String EDITOR_LOGFILE = "logfile";
    public static final int COMBOBOX_MAX_VISIBLE_SIZE = 12;

    public static Preferences getPreferences() {
        if (cayennePrefs == null) {
            UpgradeCayennePreference decoratedPref = new UpgradeCayennePreference(new CayennePreference());
            cayennePrefs = decoratedPref.getCayennePreference();
            cayennePrefs.addPreferenceChangeListener(new ModelerPreferences());
        }
        return cayennePrefs;
    }

    public static Preferences getEditorPreferences() {
        return ModelerPreferences.getPreferences().node("editor");
    }

    public static Preferences getLastProjFilesPref() {
        return ModelerPreferences.getEditorPreferences().node("lastSeveralProjectFiles");
    }

    public static List<File> getLastProjFiles() {
        String[] keys;
        Preferences filesPrefs = ModelerPreferences.getLastProjFilesPref();
        try {
            keys = filesPrefs.keys();
        }
        catch (BackingStoreException e) {
            logObj.warn("Error reading preferences file.", e);
            return new ArrayList<File>();
        }
        int len = keys.length;
        ArrayList<File> lastProjectsFiles = new ArrayList<File>(len);
        for (int i = 0; i < len; ++i) {
            File file;
            String fileName = filesPrefs.get(Integer.toString(i), "");
            if (fileName.isEmpty() || lastProjectsFiles.contains(file = new File(fileName)) || !file.exists()) continue;
            lastProjectsFiles.add(file);
        }
        return lastProjectsFiles;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        evt.getNode().put(evt.getKey(), evt.getNewValue());
    }

    static {
        logObj = LoggerFactory.getLogger(ModelerPreferences.class);
    }
}

