/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.access.dbsync.SkipSchemaUpdateStrategy;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateNodeUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateNodeAction
extends CayenneAction {
    public CreateNodeAction(Application application) {
        super(CreateNodeAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create DataNode";
    }

    @Override
    public String getIconName() {
        return "icon-node.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        DataNodeDescriptor node = this.buildDataNode();
        this.createDataNode(node);
        this.application.getUndoManager().addEdit(new CreateNodeUndoableEdit(this.application, node));
    }

    public void createDataNode(DataNodeDescriptor node) {
        DataChannelDescriptor domain = (DataChannelDescriptor)this.getProjectController().getProject().getRootNode();
        domain.getNodeDescriptors().add(node);
        this.getProjectController().fireDataNodeEvent(new DataNodeEvent((Object)this, node, 2));
        this.getProjectController().fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, domain, node));
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        return object != null && ((DataNodeDescriptor)object).getDataChannelDescriptor() != null;
    }

    public DataNodeDescriptor buildDataNode() {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataNodeDescriptor node = this.buildDataNode(domain);
        DataSourceInfo src = new DataSourceInfo();
        node.setDataSourceDescriptor(src);
        node.setDataSourceFactoryType(XMLPoolingDataSourceFactory.class.getName());
        node.setSchemaUpdateStrategyType(SkipSchemaUpdateStrategy.class.getName());
        return node;
    }

    DataNodeDescriptor buildDataNode(DataChannelDescriptor dataChannelDescriptor) {
        DataNodeDescriptor node = new DataNodeDescriptor();
        node.setName(NameBuilder.builder(node, dataChannelDescriptor).name());
        node.setDataChannelDescriptor(dataChannelDescriptor);
        return node;
    }
}

