/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.welcome;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import org.apache.cayenne.modeler.dialog.welcome.RecentFileListModel;

class RecentFileListRenderer
extends DefaultListCellRenderer
implements MouseInputListener {
    private final Color ROLLOVER_BACKGROUND = new Color(223, 223, 223);
    private final JList<String> list;
    private int rolloverRow;
    private OnFileClickListener listener;

    RecentFileListRenderer(JList<String> list, OnFileClickListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener parameter is null");
        }
        list.addMouseListener(this);
        list.addMouseMotionListener(this);
        this.list = list;
        this.listener = listener;
        this.rolloverRow = -1;
        this.setHorizontalTextPosition(10);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, false, false);
        this.setMargin(8, 15, 8, 15);
        if (this.rolloverRow == index) {
            this.setOpaque(true);
            this.setBackground(this.ROLLOVER_BACKGROUND);
            this.setToolTipText(this.getSelectedFile().getAbsolutePath());
        } else {
            this.setOpaque(false);
        }
        return this;
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setBorder(new EmptyBorder(top, left, bottom, right));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.rolloverRow = -1;
        this.list.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private File getSelectedFile() {
        if (this.rolloverRow == -1) {
            return null;
        }
        return ((RecentFileListModel)this.list.getModel()).getFullElementAt(this.rolloverRow);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e) || this.rolloverRow == -1) {
            return;
        }
        this.listener.onFileSelect(this.getSelectedFile());
        this.rolloverRow = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Rectangle bounds = this.list.getCellBounds(0, this.list.getModel().getSize() - 1);
        int newRow = this.list.getModel().getSize() > 0 && !bounds.contains(e.getPoint()) ? -1 : this.list.locationToIndex(e.getPoint());
        if (this.rolloverRow != newRow) {
            this.rolloverRow = newRow;
            this.list.repaint();
        }
    }

    static interface OnFileClickListener {
        public void onFileSelect(File var1);
    }
}

