/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.UpdateBuilder;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.BaseBatchTranslator;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.UpdateBatchQuery;

public class UpdateBatchTranslator
extends BaseBatchTranslator<UpdateBatchQuery>
implements BatchTranslator {
    public UpdateBatchTranslator(UpdateBatchQuery query, DbAdapter adapter) {
        super(query, adapter);
    }

    @Override
    public String getSql() {
        UpdateBatchQuery query = (UpdateBatchQuery)this.context.getQuery();
        UpdateBuilder updateBuilder = SQLBuilder.update(this.context.getRootDbEntity());
        for (DbAttribute attr : query.getUpdatedAttributes()) {
            updateBuilder.set(SQLBuilder.column(attr.getName()).attribute(attr).eq(SQLBuilder.value(1).attribute(attr)));
        }
        updateBuilder.where(this.buildQualifier(query.getQualifierAttributes()));
        return this.doTranslate(updateBuilder);
    }

    @Override
    protected boolean isNullAttribute(DbAttribute attribute) {
        return ((UpdateBatchQuery)this.context.getQuery()).isNull(attribute);
    }

    @Override
    public DbAttributeBinding[] updateBindings(BatchQueryRow row) {
        int i;
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)this.context.getQuery();
        int j = 0;
        for (i = 0; i < updateBatch.getUpdatedAttributes().size(); ++i) {
            Object value = row.getValue(i);
            ExtendedType extendedType = value == null ? this.context.getAdapter().getExtendedTypes().getDefaultType() : this.context.getAdapter().getExtendedTypes().getRegisteredType(value.getClass());
            this.bindings[j].include(++j, value, extendedType);
        }
        for (DbAttribute attribute : updateBatch.getQualifierAttributes()) {
            if (updateBatch.isNull(attribute)) {
                ++i;
                continue;
            }
            Object value = row.getValue(i);
            ExtendedType extendedType = this.context.getAdapter().getExtendedTypes().getRegisteredType(value.getClass());
            this.bindings[j].include(++j, value, extendedType);
            ++i;
        }
        return this.bindings;
    }
}

