/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

public class DefaultOperationObserver
implements OperationObserver {
    protected List<Throwable> globalExceptions = new ArrayList<Throwable>();
    protected Map<Query, Throwable> queryExceptions = new HashMap<Query, Throwable>();

    public void printExceptions(PrintWriter out) {
        if (this.globalExceptions.size() > 0) {
            if (this.globalExceptions.size() == 1) {
                out.println("Global Exception:");
            } else {
                out.println("Global Exceptions:");
            }
            for (Throwable th : this.globalExceptions) {
                th.printStackTrace(out);
            }
        }
        if (this.queryExceptions.size() > 0) {
            if (this.queryExceptions.size() == 1) {
                out.println("Query Exception:");
            } else {
                out.println("Query Exceptions:");
            }
            for (Query query : this.queryExceptions.keySet()) {
                Throwable th = this.queryExceptions.get(query);
                th.printStackTrace(out);
            }
        }
    }

    public List<Throwable> getGlobalExceptions() {
        return this.globalExceptions;
    }

    public Map<Query, Throwable> getQueryExceptions() {
        return this.queryExceptions;
    }

    public boolean hasExceptions() {
        return this.globalExceptions.size() > 0 || this.queryExceptions.size() > 0;
    }

    @Override
    public void nextCount(Query query, int resultCount) {
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
    }

    public void nextRows(Query query, ResultIterator it) {
        if (it != null) {
            it.close();
        }
    }

    @Override
    public void nextGeneratedRows(Query query, ResultIterator<?> keys, List<ObjectId> idsToUpdate) {
        if (keys != null) {
            keys.close();
        }
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        this.queryExceptions.put(query, Util.unwindException(ex));
    }

    @Override
    public void nextGlobalException(Exception ex) {
        this.globalExceptions.add(Util.unwindException(ex));
    }

    @Override
    public boolean isIteratedResult() {
        return false;
    }
}

