/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import org.apache.cayenne.access.sqlbuilder.InsertBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.BaseBatchTranslator;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;

public class InsertBatchTranslator
extends BaseBatchTranslator<InsertBatchQuery>
implements BatchTranslator {
    public InsertBatchTranslator(InsertBatchQuery query, DbAdapter adapter) {
        super(query, adapter);
    }

    @Override
    public String getSql() {
        InsertBatchQuery query = (InsertBatchQuery)this.context.getQuery();
        InsertBuilder insertBuilder = SQLBuilder.insert(this.context.getRootDbEntity());
        for (DbAttribute attribute : query.getDbAttributes()) {
            if (this.excludeInBatch(attribute)) continue;
            insertBuilder.column(SQLBuilder.column(attribute.getName()).attribute(attribute)).value(SQLBuilder.value(1).attribute(attribute));
        }
        return this.doTranslate(insertBuilder);
    }

    @Override
    public DbAttributeBinding[] updateBindings(BatchQueryRow row) {
        InsertBatchQuery query = (InsertBatchQuery)this.context.getQuery();
        int i = 0;
        int j = 0;
        for (DbAttribute attribute : query.getDbAttributes()) {
            Object value;
            if (this.excludeInBatch(attribute)) {
                ++i;
                continue;
            }
            ExtendedType extendedType = (value = row.getValue(i++)) != null ? this.context.getAdapter().getExtendedTypes().getRegisteredType(value.getClass()) : this.context.getAdapter().getExtendedTypes().getDefaultType();
            this.bindings[j].include(++j, value, extendedType);
        }
        return this.bindings;
    }

    protected boolean excludeInBatch(DbAttribute attribute) {
        return attribute.isGenerated() && (!attribute.isPrimaryKey() || this.context.getAdapter().supportsGeneratedKeys());
    }

    @Override
    protected boolean isNullAttribute(DbAttribute attribute) {
        return false;
    }
}

