/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;
import org.apache.cayenne.query.Ordering;

abstract class OrderingAbstractStage
implements TranslationStage {
    OrderingAbstractStage() {
    }

    protected void processOrdering(QualifierTranslator qualifierTranslator, TranslatorContext context, Ordering ordering) {
        Node orderingNode;
        Expression orderExp = ordering.getSortSpec();
        NodeBuilder nodeBuilder = SQLBuilder.node(qualifierTranslator.translate(orderExp));
        if (ordering.isCaseInsensitive()) {
            nodeBuilder = SQLBuilder.function("UPPER", nodeBuilder);
        }
        if (this.orderColumnAbsent(context, orderingNode = nodeBuilder.build())) {
            ResultNodeDescriptor descriptor = context.addResultNode((Node)orderingNode.deepCopy());
            if (orderExp instanceof ASTAggregateFunctionCall) {
                descriptor.setAggregate(true);
            }
        }
    }

    private boolean orderColumnAbsent(TranslatorContext context, Node orderingNode) {
        return context.getResultNodeList().stream().noneMatch(result -> result.getNode().deepEquals(orderingNode));
    }
}

