/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen.templateeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.FindView;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorController;
import org.apache.cayenne.modeler.editor.cgen.templateeditor.TemplateEditorView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.util.Util;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class FindController
extends CayenneController
implements ActionListener {
    private FindView view;
    protected TemplateEditorView parentView;
    private JButton nextButton;
    private JButton prevButton;
    protected static final String TEXT_NOT_FOUND_MSG = "Text not found";
    protected static final String FIND_NEXT = "FindNext";
    private static final String FIND_PREV = "FindPrev";

    public FindController(TemplateEditorController parent) {
        super(parent);
        this.parentView = parent.getView();
        this.initComponents();
        this.initListeners();
    }

    protected void initComponents() {
        this.view = new FindView();
        this.nextButton = this.view.getNextButton();
        this.prevButton = this.view.getPrevButton();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initListeners() {
        this.nextButton.setActionCommand(FIND_NEXT);
        this.nextButton.addActionListener(this);
        this.prevButton.setActionCommand(FIND_PREV);
        this.prevButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        boolean forward = FIND_NEXT.equals(command);
        SearchContext context = this.getSearchContext(forward, this.view);
        if (context == null) {
            return;
        }
        boolean found = SearchEngine.find(this.parentView.getEditingTemplatePane(), context).wasFound();
        if (!found) {
            JOptionPane.showMessageDialog(this.view, TEXT_NOT_FOUND_MSG);
        }
    }

    protected SearchContext getSearchContext(boolean forward, FindView view) {
        SearchContext context = new SearchContext();
        String text = view.getSearchField().getText();
        if (Util.isEmptyString(text)) {
            return null;
        }
        context.setSearchFor(text);
        context.setMatchCase(view.getMatchCaseCB().isSelected());
        context.setRegularExpression(view.getRegexCB().isSelected());
        context.setWholeWord(view.getWholeWordCB().isSelected());
        context.setSearchForward(forward);
        return context;
    }

    public void startupAction() {
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }
}

