/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.Key;
import java.util.Arrays;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.Header;
import org.apache.cayenne.crypto.transformer.bytes.HmacCreator;

class HmacDecryptor
extends HmacCreator
implements BytesDecryptor {
    BytesDecryptor delegate;

    HmacDecryptor(BytesDecryptor delegate, Header header, Key key) {
        super(header, key);
        this.delegate = delegate;
    }

    @Override
    public byte[] decrypt(byte[] input, int inputOffset, Key key) {
        byte hmacLength;
        if ((hmacLength = input[inputOffset++]) <= 0) {
            throw new CayenneCryptoException("Input is corrupted: invalid HMAC length.", new Object[0]);
        }
        byte[] receivedHmac = new byte[hmacLength];
        byte[] decrypted = this.delegate.decrypt(input, inputOffset + hmacLength, key);
        byte[] realHmac = this.createHmac(decrypted);
        System.arraycopy(input, inputOffset, receivedHmac, 0, hmacLength);
        if (!Arrays.equals(receivedHmac, realHmac)) {
            throw new CayenneCryptoException("Input is corrupted: wrong HMAC.", new Object[0]);
        }
        return decrypted;
    }
}

