/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

abstract class BaseQueryValidator<T extends QueryDescriptor>
extends ConfigurationNodeValidator<T> {
    public BaseQueryValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(T node, ValidationResult validationResult) {
        this.validateQuery(node, validationResult);
    }

    protected ConfigurationNodeValidator.Performer<T> validateQuery(T query, ValidationResult validationResult) {
        return this.on(query, validationResult).performIfEnabled(Inspection.QUERY_NO_NAME, this::checkForName).performIfEnabled(Inspection.QUERY_NAME_DUPLICATE, this::checkForNameDuplicates).performIfEnabled(Inspection.QUERY_MULTI_CACHE_GROUP, this::checkForMultiCacheGroup);
    }

    void checkForName(T query, ValidationResult validationResult) {
        String name = query.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, query, "Unnamed " + query.getType(), new Object[0]);
        }
    }

    void checkForNameDuplicates(T query, ValidationResult validationResult) {
        String name = query.getName();
        DataMap map = query.getDataMap();
        if (map == null || Util.isEmptyString((CharSequence)name)) {
            return;
        }
        if (this.hasDuplicateQueryDescriptorInDataMap((QueryDescriptor)query, map)) {
            this.addFailure(validationResult, query, "Duplicate query name: %s", name);
            return;
        }
        DataChannelDescriptor domain = query.getDataMap().getDataChannelDescriptor();
        if (domain == null) {
            return;
        }
        for (DataMap nextMap : domain.getDataMaps()) {
            if (nextMap == map || !this.hasDuplicateQueryDescriptorInDataMap((QueryDescriptor)query, nextMap)) continue;
            this.addFailure(validationResult, query, "Duplicate %s name in another DataMap: %s", query.getType(), name);
            return;
        }
    }

    void checkForMultiCacheGroup(T query, ValidationResult validationResult) {
        String cacheGroup = query.getProperty("cayenne.GenericSelectQuery.cacheGroups");
        if (cacheGroup != null && cacheGroup.contains(",")) {
            this.addFailure(validationResult, query, "Invalid cache group '%s', multiple groups are deprecated", cacheGroup);
        }
    }

    private boolean hasDuplicateQueryDescriptorInDataMap(QueryDescriptor queryDescriptor, DataMap dataMap) {
        for (QueryDescriptor otherQuery : dataMap.getQueryDescriptors()) {
            if (otherQuery == queryDescriptor || !queryDescriptor.getName().equals(otherQuery.getName())) continue;
            return true;
        }
        return false;
    }
}

